/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.exception;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;

public class OrganizationParentException
extends PortalException {
    public OrganizationParentException() {
    }

    public OrganizationParentException(String msg) {
        super(msg);
    }

    public OrganizationParentException(String msg, Throwable throwable) {
        super(msg, throwable);
    }

    public OrganizationParentException(Throwable throwable) {
        super(throwable);
    }

    public static class MustNotHaveChildren
    extends OrganizationParentException {
        private String _type;

        public MustNotHaveChildren(String type) {
            super("Organization of type " + type + " must not have children");
            this._type = type;
        }

        public String getType() {
            return this._type;
        }
    }

    public static class MustHaveValidChildType
    extends OrganizationParentException {
        private final String _childOrganizationType;
        private final String _parentOrganizationType;

        public MustHaveValidChildType(String childOrganizationType, String parentOrganizationType) {
            super(StringBundler.concat((String[])new String[]{"Organization of type ", childOrganizationType, " is not allowed as a child of ", parentOrganizationType}));
            this._childOrganizationType = childOrganizationType;
            this._parentOrganizationType = parentOrganizationType;
        }

        public String getChildOrganizationType() {
            return this._childOrganizationType;
        }

        public String getParentOrganizationType() {
            return this._parentOrganizationType;
        }
    }

    public static class MustBeRootable
    extends OrganizationParentException {
        private String _type;

        public MustBeRootable(String type) {
            super("Organization of type " + type + " must not be a root organization");
            this._type = type;
        }

        public String getType() {
            return this._type;
        }
    }
}

