/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.model;

import com.liferay.petra.string.StringBundler;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class PortletCategory
implements Serializable {
    private static final String _DELIMITER = "//";
    private final String _name;
    private PortletCategory _parentPortletCategory;
    private String _path;
    private final Map<String, PortletCategory> _portletCategories = new ConcurrentHashMap<String, PortletCategory>();
    private final Set<String> _portletIds = ConcurrentHashMap.newKeySet();

    public PortletCategory() {
        this("root");
    }

    public PortletCategory(String name) {
        this(name, new HashSet<String>());
    }

    public PortletCategory(String name, Set<String> portletIds) {
        this._portletIds.addAll(portletIds);
        if (name.contains(_DELIMITER)) {
            int index = name.lastIndexOf(_DELIMITER);
            this._name = name.substring(index + _DELIMITER.length());
            String parentName = name.substring(0, index);
            PortletCategory parentPortletCategory = new PortletCategory(parentName);
            parentPortletCategory.addCategory(this);
        } else {
            this._name = name;
            this._parentPortletCategory = null;
            this._path = name;
        }
    }

    public void addCategory(PortletCategory portletCategory) {
        portletCategory.setParentCategory(this);
        String path = StringBundler.concat((String[])new String[]{this._path, _DELIMITER, portletCategory.getName()});
        portletCategory.setPath(path);
        this._portletCategories.put(portletCategory.getName(), portletCategory);
    }

    public Collection<PortletCategory> getCategories() {
        return Collections.unmodifiableCollection(this._portletCategories.values());
    }

    public PortletCategory getCategory(String name) {
        return this._portletCategories.get(name);
    }

    public String getName() {
        return this._name;
    }

    public PortletCategory getParentCategory() {
        return this._parentPortletCategory;
    }

    public String getPath() {
        return this._path;
    }

    public Set<String> getPortletIds() {
        return this._portletIds;
    }

    public PortletCategory getRootCategory() {
        if (this._parentPortletCategory == null) {
            return this;
        }
        return this._parentPortletCategory.getRootCategory();
    }

    public boolean isHidden() {
        return this._name.equals("category.hidden");
    }

    public void merge(PortletCategory newPortletCategory) {
        this.merge(this, newPortletCategory);
    }

    public void separate(Set<String> portletIds) {
        for (PortletCategory portletCategory : this._portletCategories.values()) {
            portletCategory.separate(portletIds);
        }
        Iterator<String> iterator = this._portletIds.iterator();
        while (iterator.hasNext()) {
            String portletId = iterator.next();
            if (!portletIds.contains(portletId)) continue;
            iterator.remove();
        }
    }

    public void separate(String portletId) {
        HashSet<String> portletIds = new HashSet<String>();
        portletIds.add(portletId);
        this.separate(portletIds);
    }

    public void setPortletIds(Set<String> portletIds) {
        this._portletIds.clear();
        this._portletIds.addAll(portletIds);
    }

    protected void merge(PortletCategory portletCategory1, PortletCategory portletCategory2) {
        Collection<PortletCategory> portletCategories = portletCategory2.getCategories();
        for (PortletCategory curPortletCategory2 : portletCategories) {
            PortletCategory curPortletCategory1 = portletCategory1.getCategory(curPortletCategory2.getName());
            if (curPortletCategory1 != null) {
                this.merge(curPortletCategory1, curPortletCategory2);
                continue;
            }
            portletCategory1.addCategory(curPortletCategory2);
        }
        Set<String> portletIds1 = portletCategory1.getPortletIds();
        Set<String> portletIds2 = portletCategory2.getPortletIds();
        portletIds1.addAll(portletIds2);
    }

    protected void setParentCategory(PortletCategory portletCategory) {
        this._parentPortletCategory = portletCategory;
    }

    protected void setPath(String path) {
        this._path = path;
    }
}

