/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.nio.intraband;

import com.liferay.portal.kernel.nio.intraband.Intraband;
import com.liferay.portal.kernel.nio.intraband.blocking.ExecutorIntraband;
import com.liferay.portal.kernel.nio.intraband.nonblocking.SelectorIntraband;
import com.liferay.portal.kernel.nio.intraband.welder.Welder;
import com.liferay.portal.kernel.nio.intraband.welder.WelderFactoryUtil;
import com.liferay.portal.kernel.nio.intraband.welder.socket.SocketWelder;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.lang.reflect.Constructor;

public class IntrabandFactoryUtil {
    private static final String _INTRABAND_IMPL = GetterUtil.getString(System.getProperty("intraband.impl"));
    private static final long _INTRABAND_TIMEOUT_DEFAULT = GetterUtil.getLong(System.getProperty("intraband.timeout.default"));

    public static Intraband createIntraband() throws IOException {
        if (Validator.isNotNull(_INTRABAND_IMPL)) {
            try {
                Class<?> intrabandClass = Class.forName(_INTRABAND_IMPL);
                Constructor<?> constructor = intrabandClass.getConstructor(Long.TYPE);
                return (Intraband)constructor.newInstance(_INTRABAND_TIMEOUT_DEFAULT);
            }
            catch (Exception exception) {
                throw new RuntimeException("Unable to instantiate " + _INTRABAND_IMPL, exception);
            }
        }
        Class<? extends Welder> welderClass = WelderFactoryUtil.getWelderClass();
        if (welderClass.equals(SocketWelder.class)) {
            return new SelectorIntraband(_INTRABAND_TIMEOUT_DEFAULT);
        }
        return new ExecutorIntraband(_INTRABAND_TIMEOUT_DEFAULT);
    }
}

