/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.nio.intraband.welder.fifo;

import com.liferay.petra.io.AutoDeleteFileInputStream;
import com.liferay.portal.kernel.nio.intraband.Intraband;
import com.liferay.portal.kernel.nio.intraband.RegistrationReference;
import com.liferay.portal.kernel.nio.intraband.welder.BaseWelder;
import com.liferay.portal.kernel.nio.intraband.welder.fifo.FIFOUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicLong;

public class FIFOWelder
extends BaseWelder {
    protected static final AtomicLong idCounter = new AtomicLong(System.currentTimeMillis());
    protected final File inputFIFOFile;
    protected final File outputFIFOFile;
    protected transient FileChannel readFileChannel;
    protected transient FileChannel writeFileChannel;

    public FIFOWelder() throws IOException {
        String tempFolderName = System.getProperty("java.io.tmpdir");
        long id = idCounter.getAndIncrement();
        this.inputFIFOFile = new File(tempFolderName, "FIFO-INPUT-" + id);
        this.outputFIFOFile = new File(tempFolderName, "FIFO-OUTPUT-" + id);
        try {
            FIFOUtil.createFIFO(this.inputFIFOFile);
            FIFOUtil.createFIFO(this.outputFIFOFile);
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    @Override
    protected void doDestroy() throws IOException {
        this.readFileChannel.close();
        this.writeFileChannel.close();
    }

    @Override
    protected RegistrationReference weldClient(Intraband intraband) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(this.inputFIFOFile);
        this.writeFileChannel = fileOutputStream.getChannel();
        AutoDeleteFileInputStream fileInputStream = new AutoDeleteFileInputStream(this.outputFIFOFile);
        this.readFileChannel = fileInputStream.getChannel();
        return intraband.registerChannel(this.readFileChannel, this.writeFileChannel);
    }

    @Override
    protected RegistrationReference weldServer(Intraband intraband) throws IOException {
        AutoDeleteFileInputStream fileInputStream = new AutoDeleteFileInputStream(this.inputFIFOFile);
        this.readFileChannel = fileInputStream.getChannel();
        FileOutputStream fileOutputStream = new FileOutputStream(this.outputFIFOFile);
        this.writeFileChannel = fileOutputStream.getChannel();
        return intraband.registerChannel(this.readFileChannel, this.writeFileChannel);
    }
}

