/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.notifications;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.UserNotificationEvent;
import com.liferay.portal.kernel.notifications.BaseUserNotificationHandler;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserNotificationEventLocalServiceUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public abstract class BaseModelUserNotificationHandler
extends BaseUserNotificationHandler {
    private static final Log _log = LogFactoryUtil.getLog(BaseModelUserNotificationHandler.class);

    protected AssetRenderer<?> getAssetRenderer(JSONObject jsonObject) {
        String className = jsonObject.getString("className");
        long classPK = jsonObject.getLong("classPK");
        return this.getAssetRenderer(className, classPK);
    }

    protected AssetRenderer<?> getAssetRenderer(String className, long classPK) {
        AssetRenderer<?> assetRenderer;
        block3: {
            AssetRendererFactory<?> assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName(className);
            if (assetRendererFactory == null) {
                return null;
            }
            assetRenderer = null;
            try {
                assetRenderer = assetRendererFactory.getAssetRenderer(classPK);
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug(exception, exception);
            }
        }
        return assetRenderer;
    }

    @Override
    protected String getBody(UserNotificationEvent userNotificationEvent, ServiceContext serviceContext) throws Exception {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject(userNotificationEvent.getPayload());
        AssetRenderer<?> assetRenderer = this.getAssetRenderer(jsonObject);
        if (assetRenderer == null) {
            UserNotificationEventLocalServiceUtil.deleteUserNotificationEvent(userNotificationEvent.getUserNotificationEventId());
            return null;
        }
        return StringUtil.replace(this.getBodyTemplate(), new String[]{"[$BODY$]", "[$TITLE$]"}, new String[]{HtmlUtil.escape(StringUtil.shorten(this.getBodyContent(jsonObject), 70)), this.getTitle(jsonObject, assetRenderer, serviceContext)});
    }

    protected String getBodyContent(JSONObject jsonObject) {
        return jsonObject.getString("entryTitle");
    }

    protected String getFormattedMessage(JSONObject jsonObject, ServiceContext serviceContext, String message, String typeName) {
        return LanguageUtil.format(serviceContext.getLocale(), message, (Object[])new String[]{HtmlUtil.escape(this._getUserFullName(jsonObject)), StringUtil.toLowerCase(HtmlUtil.escape(typeName))}, false);
    }

    @Override
    protected String getLink(UserNotificationEvent userNotificationEvent, ServiceContext serviceContext) throws Exception {
        String portalURLDomain;
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject(userNotificationEvent.getPayload());
        String entryURL = jsonObject.getString("entryURL");
        if (Validator.isNull(entryURL)) {
            return "";
        }
        String entryURLDomain = HttpUtil.getDomain(entryURL);
        if (!entryURLDomain.equals(portalURLDomain = HttpUtil.getDomain(serviceContext.getPortalURL()))) {
            entryURL = StringUtil.replaceFirst(entryURL, entryURLDomain, portalURLDomain);
        }
        return entryURL;
    }

    protected String getTitle(JSONObject jsonObject, AssetRenderer<?> assetRenderer, ServiceContext serviceContext) {
        String message = "";
        AssetRendererFactory<?> assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName(assetRenderer.getClassName());
        String typeName = assetRendererFactory.getTypeName(serviceContext.getLocale());
        int notificationType = jsonObject.getInt("notificationType");
        if (notificationType == 0) {
            message = "x-added-a-new-x";
        } else if (notificationType == 1) {
            message = "x-updated-a-x";
        }
        return this.getFormattedMessage(jsonObject, serviceContext, message, typeName);
    }

    private String _getUserFullName(JSONObject jsonObject) {
        String fullName = jsonObject.getString("fullName");
        if (Validator.isNotNull(fullName)) {
            return fullName;
        }
        return PortalUtil.getUserName(jsonObject.getLong("userId"), "");
    }
}

