/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.process.local;

import com.liferay.portal.kernel.concurrent.AsyncBroker;
import com.liferay.portal.kernel.concurrent.FutureListener;
import com.liferay.portal.kernel.concurrent.NoticeableFuture;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.process.ProcessCallable;
import com.liferay.portal.kernel.process.ProcessChannel;
import com.liferay.portal.kernel.process.local.RequestProcessCallable;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;

public class LocalProcessChannel<T extends Serializable>
implements ProcessChannel<T> {
    private static final Log _log = LogFactoryUtil.getLog(LocalProcessChannel.class);
    private final AsyncBroker<Long, Serializable> _asyncBroker;
    private final AtomicLong _idGenerator = new AtomicLong();
    private final NoticeableFuture<T> _noticeableFuture;
    private final ObjectOutputStream _objectOutputStream;

    public LocalProcessChannel(NoticeableFuture<T> noticeableFuture, ObjectOutputStream objectOutputStream, AsyncBroker<Long, Serializable> asyncBroker) {
        this._noticeableFuture = noticeableFuture;
        this._objectOutputStream = objectOutputStream;
        this._asyncBroker = asyncBroker;
        this._noticeableFuture.addFutureListener(new FutureListener<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void complete(Future<T> future) {
                try {
                    LocalProcessChannel.this._objectOutputStream.close();
                }
                catch (IOException ioException) {
                    if (_log.isDebugEnabled()) {
                        _log.debug(ioException, ioException);
                    }
                }
                finally {
                    Map map = LocalProcessChannel.this._asyncBroker.getOpenBids();
                    for (NoticeableFuture noticeableFuture : map.values()) {
                        noticeableFuture.cancel(true);
                    }
                }
            }
        });
    }

    @Override
    public NoticeableFuture<T> getProcessNoticeableFuture() {
        return this._noticeableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V extends Serializable> NoticeableFuture<V> write(ProcessCallable<V> processCallable) {
        long id = this._idGenerator.getAndIncrement();
        NoticeableFuture<Serializable> noticeableFuture = this._asyncBroker.post(id);
        try {
            ObjectOutputStream objectOutputStream = this._objectOutputStream;
            synchronized (objectOutputStream) {
                this._objectOutputStream.writeObject(new RequestProcessCallable<V>(id, processCallable));
                this._objectOutputStream.flush();
            }
        }
        catch (IOException ioException) {
            this._asyncBroker.takeWithException(id, ioException);
        }
        return noticeableFuture;
    }
}

