/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.resource.bundle;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader;
import com.liferay.portal.kernel.util.AggregateResourceBundle;
import com.liferay.portal.kernel.util.LocaleUtil;
import java.util.ArrayList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class AggregateResourceBundleLoader
implements ResourceBundleLoader {
    private static final Log _log = LogFactoryUtil.getLog(AggregateResourceBundleLoader.class);
    private final ResourceBundleLoader[] _resourceBundleLoaders;

    public AggregateResourceBundleLoader(ResourceBundleLoader ... resourceBundleLoaders) {
        for (int i = 0; i < resourceBundleLoaders.length; ++i) {
            if (resourceBundleLoaders[i] != null) continue;
            throw new NullPointerException("Null resource bundle loader at index " + i);
        }
        this._resourceBundleLoaders = resourceBundleLoaders;
    }

    @Override
    public ResourceBundle loadResourceBundle(Locale locale) {
        ArrayList<ResourceBundle> resourceBundles = new ArrayList<ResourceBundle>();
        for (ResourceBundleLoader resourceBundleLoader : this._resourceBundleLoaders) {
            try {
                ResourceBundle resourceBundle = resourceBundleLoader.loadResourceBundle(locale);
                if (resourceBundle == null) continue;
                resourceBundles.add(resourceBundle);
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug(exception, exception);
            }
        }
        if (resourceBundles.isEmpty()) {
            String languageId = LocaleUtil.toLanguageId(locale);
            throw new MissingResourceException(StringBundler.concat((Object[])new Object[]{"Resource bundle loader ", this, " was unable to load resource bundle for ", languageId}), "", languageId);
        }
        if (resourceBundles.size() == 1) {
            return (ResourceBundle)resourceBundles.get(0);
        }
        return new AggregateResourceBundle(resourceBundles.toArray(new ResourceBundle[0]));
    }
}

