/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.model.BaseModel;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public class BaseModelSearchResult<T extends BaseModel<T>>
implements Serializable {
    private final List<T> _baseModels;
    private final int _length;

    public BaseModelSearchResult(List<T> baseModels, int length) {
        this._baseModels = baseModels == null ? Collections.emptyList() : baseModels;
        this._length = length;
    }

    public BaseModelSearchResult(List<T> baseModels, Long length) {
        this(baseModels, length.intValue());
    }

    public List<T> getBaseModels() {
        return this._baseModels;
    }

    public int getLength() {
        return this._length;
    }

    public String toString() {
        if (this._baseModels.isEmpty()) {
            return StringBundler.concat((Object[])new Object[]{"{baseModels={}, length=", this._length, "]"});
        }
        StringBundler sb = new StringBundler(2 * this._baseModels.size() + 3);
        sb.append("{baseModels={");
        for (BaseModel baseModel : this._baseModels) {
            sb.append((Object)baseModel);
            sb.append(", ");
        }
        sb.setStringAt("]", sb.index() - 1);
        sb.append(", length=");
        sb.append(this._length);
        sb.append("]");
        return sb.toString();
    }
}

