/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.petra.string.StringPool;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.SetUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class QueryConfig
implements Serializable {
    public static final String LOCALE = "locale";
    public static final String SEARCH_SUBFOLDERS = "search.subfolders";
    private static final String _ALTERNATE_UID_FIELD_NAME = "alternateUidFieldName";
    private static final String _HIGHLIGHT_FIELD_NAMES = "highlightFieldNames";
    private static final String _HITS_PROCESSING_ENABLED = "hitsProcessingEnabled";
    private static final boolean _INDEX_SEARCH_COLLATED_SPELL_CHECK_RESULT_ENABLED = GetterUtil.getBoolean(PropsUtil.get("index.search.collated.spell.check.result.enabled"), true);
    private static final int _INDEX_SEARCH_COLLATED_SPELL_CHECK_RESULT_SCORES_THRESHOLD = GetterUtil.getInteger(PropsUtil.get("index.search.collated.spell.check.result.scores.threshold"), 50);
    private static final String _INDEX_SEARCH_HIGHLIGHT_ENABLED = "indexSearchHighlightEnabled";
    private static final int _INDEX_SEARCH_HIGHLIGHT_FRAGMENT_SIZE = GetterUtil.getInteger(PropsUtil.get("index.search.highlight.fragment.size"));
    private static final boolean _INDEX_SEARCH_HIGHLIGHT_REQUIRE_FIELD_MATCH = GetterUtil.getBoolean(PropsUtil.get("index.search.highlight.require.field.match"));
    private static final int _INDEX_SEARCH_HIGHLIGHT_SNIPPET_SIZE = GetterUtil.getInteger(PropsUtil.get("index.search.highlight.snippet.size"));
    private static final boolean _INDEX_SEARCH_QUERY_INDEXING_ENABLED = GetterUtil.getBoolean(PropsUtil.get("index.search.query.indexing.enabled"), true);
    private static final int _INDEX_SEARCH_QUERY_INDEXING_THRESHOLD = GetterUtil.getInteger(PropsUtil.get("index.search.query.indexing.threshold"), 50);
    private static final boolean _INDEX_SEARCH_QUERY_SUGGESTION_ENABLED = GetterUtil.getBoolean(PropsUtil.get("index.search.query.suggestion.enabled"), true);
    private static final int _INDEX_SEARCH_QUERY_SUGGESTION_MAX = GetterUtil.getInteger(PropsUtil.get("index.search.query.suggestion.max"), 5);
    private static final int _INDEX_SEARCH_QUERY_SUGGESTION_SCORES_THRESHOLD = GetterUtil.getInteger(PropsUtil.get("index.search.query.suggestion.scores.threshold"), 50);
    private static final boolean _INDEX_SEARCH_SCORING_ENABLED = GetterUtil.getBoolean(PropsUtil.get("index.search.scoring.enabled"));
    private static final String _SELECTED_FIELD_NAMES = "selectedFieldNames";
    private static final String _SELECTED_INDEX_NAMES = "selectedIndexNames";
    private static final String _SELECTED_TYPES = "selectedTypes";
    private final Map<String, Serializable> _attributes = new HashMap<String, Serializable>();

    public void addHighlightFieldNames(String ... highlightFieldNames) {
        Set<String> highlightFieldNamesSet = SetUtil.fromArray((String[])this._attributes.get(_HIGHLIGHT_FIELD_NAMES));
        Collections.addAll(highlightFieldNamesSet, highlightFieldNames);
        this._attributes.put(_HIGHLIGHT_FIELD_NAMES, (Serializable)highlightFieldNamesSet.toArray(new String[0]));
    }

    public void addSelectedFieldNames(String ... selectedFieldNames) {
        Set<String> selectedFieldNamesSet = SetUtil.fromArray((String[])this._attributes.get(_SELECTED_FIELD_NAMES));
        Collections.addAll(selectedFieldNamesSet, selectedFieldNames);
        this._attributes.put(_SELECTED_FIELD_NAMES, (Serializable)selectedFieldNamesSet.toArray(new String[0]));
    }

    public String getAlternateUidFieldName() {
        return (String)((Object)this._attributes.get(_ALTERNATE_UID_FIELD_NAME));
    }

    public Serializable getAttribute(String name) {
        return this._attributes.get(name);
    }

    public Map<String, Serializable> getAttributes() {
        return this._attributes;
    }

    public int getCollatedSpellCheckResultScoresThreshold() {
        return GetterUtil.getInteger(this._attributes.get("index.search.collated.spell.check.result.scores.threshold"), _INDEX_SEARCH_COLLATED_SPELL_CHECK_RESULT_SCORES_THRESHOLD);
    }

    public String[] getHighlightFieldNames() {
        String[] highlightFieldNames = (String[])this._attributes.get(_HIGHLIGHT_FIELD_NAMES);
        if (highlightFieldNames != null) {
            return highlightFieldNames;
        }
        return StringPool.EMPTY_ARRAY;
    }

    public int getHighlightFragmentSize() {
        return GetterUtil.getInteger(this._attributes.get("index.search.highlight.fragment.size"), _INDEX_SEARCH_HIGHLIGHT_FRAGMENT_SIZE);
    }

    public int getHighlightSnippetSize() {
        return GetterUtil.getInteger(this._attributes.get("index.search.highlight.snippet.size"), _INDEX_SEARCH_HIGHLIGHT_SNIPPET_SIZE);
    }

    public Locale getLocale() {
        Locale locale = (Locale)this._attributes.get(LOCALE);
        if (locale == null) {
            locale = LocaleUtil.getMostRelevantLocale();
        }
        return locale;
    }

    public int getQueryIndexingThreshold() {
        return GetterUtil.getInteger(this._attributes.get("index.search.query.indexing.threshold"), _INDEX_SEARCH_QUERY_INDEXING_THRESHOLD);
    }

    public int getQuerySuggestionMax() {
        return GetterUtil.getInteger(this._attributes.get("index.search.query.suggestion.max"), _INDEX_SEARCH_QUERY_SUGGESTION_MAX);
    }

    public int getQuerySuggestionScoresThreshold() {
        return GetterUtil.getInteger(this._attributes.get("index.search.query.suggestion.scores.threshold"), _INDEX_SEARCH_QUERY_SUGGESTION_SCORES_THRESHOLD);
    }

    public String[] getSelectedFieldNames() {
        Object[] selectedFieldNames = (String[])this._attributes.get(_SELECTED_FIELD_NAMES);
        if (ArrayUtil.isEmpty(selectedFieldNames)) {
            return StringPool.EMPTY_ARRAY;
        }
        return selectedFieldNames;
    }

    public String[] getSelectedIndexNames() {
        Object[] selectedIndexNames = (String[])this._attributes.get(_SELECTED_INDEX_NAMES);
        if (ArrayUtil.isEmpty(selectedIndexNames)) {
            return StringPool.EMPTY_ARRAY;
        }
        return selectedIndexNames;
    }

    public String[] getSelectedTypes() {
        Object[] selectedTypes = (String[])this._attributes.get(_SELECTED_TYPES);
        if (ArrayUtil.isEmpty(selectedTypes)) {
            return StringPool.EMPTY_ARRAY;
        }
        return selectedTypes;
    }

    public boolean isAllFieldsSelected() {
        Object[] selectedFieldNames = this.getSelectedFieldNames();
        return ArrayUtil.isEmpty(selectedFieldNames) || selectedFieldNames.length == 1 && ((String)selectedFieldNames[0]).equals("*");
    }

    public boolean isCollatedSpellCheckResultEnabled() {
        return GetterUtil.getBoolean(this._attributes.get("index.search.collated.spell.check.result.enabled"), _INDEX_SEARCH_COLLATED_SPELL_CHECK_RESULT_ENABLED);
    }

    public boolean isHighlightEnabled() {
        return GetterUtil.getBoolean(this._attributes.get(_INDEX_SEARCH_HIGHLIGHT_ENABLED));
    }

    public boolean isHighlightRequireFieldMatch() {
        return GetterUtil.getBoolean(this._attributes.get("index.search.highlight.require.field.match"), _INDEX_SEARCH_HIGHLIGHT_REQUIRE_FIELD_MATCH);
    }

    public boolean isHitsProcessingEnabled() {
        return GetterUtil.getBoolean(this._attributes.get(_HITS_PROCESSING_ENABLED), true);
    }

    public boolean isQueryIndexingEnabled() {
        return GetterUtil.getBoolean(this._attributes.get("index.search.query.indexing.enabled"), _INDEX_SEARCH_QUERY_INDEXING_ENABLED);
    }

    public boolean isQuerySuggestionEnabled() {
        return GetterUtil.getBoolean(this._attributes.get("index.search.query.suggestion.enabled"), _INDEX_SEARCH_QUERY_SUGGESTION_ENABLED);
    }

    public boolean isScoreEnabled() {
        return GetterUtil.getBoolean(this._attributes.get("index.search.scoring.enabled"), _INDEX_SEARCH_SCORING_ENABLED);
    }

    public boolean isSearchSubfolders() {
        return GetterUtil.getBoolean(this._attributes.get(SEARCH_SUBFOLDERS));
    }

    public Serializable removeAttribute(String name) {
        return this._attributes.remove(name);
    }

    public void setAlternateUidFieldName(String name) {
        this._attributes.put(_ALTERNATE_UID_FIELD_NAME, (Serializable)((Object)name));
    }

    public void setAttribute(String name, Serializable value) {
        this._attributes.put(name, value);
    }

    public void setCollatedSpellCheckResultEnabled(boolean collatedSpellCheckResultEnabled) {
        this._attributes.put("index.search.collated.spell.check.result.enabled", Boolean.valueOf(collatedSpellCheckResultEnabled));
    }

    public void setCollatedSpellCheckResultScoresThreshold(int collatedSpellCheckResultScoresThreshold) {
        this._attributes.put("index.search.collated.spell.check.result.scores.threshold", Integer.valueOf(collatedSpellCheckResultScoresThreshold));
    }

    public void setHighlightEnabled(boolean highlightEnabled) {
        this._attributes.put(_INDEX_SEARCH_HIGHLIGHT_ENABLED, Boolean.valueOf(highlightEnabled));
    }

    public void setHighlightFieldNames(String ... highlightFieldNames) {
        this._attributes.put(_HIGHLIGHT_FIELD_NAMES, (Serializable)highlightFieldNames);
    }

    public void setHighlightFragmentSize(int highlightFragmentSize) {
        this._attributes.put("index.search.highlight.fragment.size", Integer.valueOf(highlightFragmentSize));
    }

    public void setHighlightRequireFieldMatch(boolean highlightRequireFieldMatch) {
        if (_INDEX_SEARCH_HIGHLIGHT_REQUIRE_FIELD_MATCH) {
            this._attributes.put("index.search.highlight.require.field.match", Boolean.valueOf(highlightRequireFieldMatch));
        } else {
            this._attributes.put("index.search.highlight.require.field.match", Boolean.valueOf(false));
        }
    }

    public void setHighlightSnippetSize(int highlightSnippetSize) {
        this._attributes.put("index.search.highlight.snippet.size", Integer.valueOf(highlightSnippetSize));
    }

    public void setHitsProcessingEnabled(boolean hitsProcessingEnabled) {
        this._attributes.put(_HITS_PROCESSING_ENABLED, Boolean.valueOf(hitsProcessingEnabled));
    }

    public void setLocale(Locale locale) {
        this._attributes.put(LOCALE, locale);
    }

    public void setQueryIndexingEnabled(boolean enabled) {
        this._attributes.put("index.search.query.indexing.enabled", Boolean.valueOf(enabled));
    }

    public void setQueryIndexingThreshold(int queryIndexingThreshold) {
        this._attributes.put("index.search.query.indexing.threshold", Integer.valueOf(queryIndexingThreshold));
    }

    public void setQuerySuggestionEnabled(boolean querySuggestionEnabled) {
        this._attributes.put("index.search.query.suggestion.enabled", Boolean.valueOf(querySuggestionEnabled));
    }

    public void setQuerySuggestionMax(int querySuggestionMax) {
        this._attributes.put("index.search.query.suggestion.max", Integer.valueOf(querySuggestionMax));
    }

    public void setQuerySuggestionScoresThreshold(int querySuggestionScoresThreshold) {
        this._attributes.put("index.search.query.suggestion.scores.threshold", Integer.valueOf(querySuggestionScoresThreshold));
    }

    @Deprecated
    public void setQuerySuggestionsMax(int querySuggestionMax) {
        this.setQuerySuggestionMax(querySuggestionMax);
    }

    public void setScoreEnabled(boolean scoreEnabled) {
        this._attributes.put("index.search.scoring.enabled", Boolean.valueOf(scoreEnabled));
    }

    public void setSearchSubfolders(boolean searchSubfolders) {
        this._attributes.put(SEARCH_SUBFOLDERS, Boolean.valueOf(searchSubfolders));
    }

    public void setSelectedFieldNames(String ... selectedFieldNames) {
        this._attributes.put(_SELECTED_FIELD_NAMES, (Serializable)selectedFieldNames);
    }

    public void setSelectedIndexNames(String ... selectedIndexNames) {
        this._attributes.put(_SELECTED_INDEX_NAMES, (Serializable)selectedIndexNames);
    }

    public void setSelectedTypes(String ... selectedTypes) {
        this._attributes.put(_SELECTED_TYPES, (Serializable)selectedTypes);
    }
}

