/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.security.auth;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.security.auth.PortletRequestWhitelist;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Collections;
import java.util.Set;

public abstract class BasePortletRequestWhitelist
implements PortletRequestWhitelist {
    private static final Log _log = LogFactoryUtil.getLog(BasePortletRequestWhitelist.class);
    private Set<String> _portletInvocationWhitelist;
    private Set<String> _portletInvocationWhitelistActions;

    public BasePortletRequestWhitelist() {
        this.resetPortletInvocationWhitelist();
        this.resetPortletInvocationWhitelistActions();
    }

    @Override
    public Set<String> getPortletInvocationWhitelist() {
        return this._portletInvocationWhitelist;
    }

    @Override
    public Set<String> getPortletInvocationWhitelistActions() {
        return this._portletInvocationWhitelistActions;
    }

    public abstract String[] getWhitelistActionsPropsValues();

    public abstract String[] getWhitelistPropsValues();

    @Override
    public boolean isPortletInvocationWhitelisted(long companyId, String portletId, String strutsAction) {
        Set<String> whitelistActions;
        Set<String> whitelist = this.getPortletInvocationWhitelist();
        if (whitelist.contains(portletId)) {
            return true;
        }
        return Validator.isNotNull(strutsAction) && (whitelistActions = this.getPortletInvocationWhitelistActions()).contains(strutsAction) && this.isValidStrutsAction(companyId, portletId, strutsAction);
    }

    @Override
    public Set<String> resetPortletInvocationWhitelist() {
        this._portletInvocationWhitelist = SetUtil.fromArray(this.getWhitelistPropsValues());
        this._portletInvocationWhitelist = this._portletInvocationWhitelist.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(this._portletInvocationWhitelist);
        return this._portletInvocationWhitelist;
    }

    @Override
    public Set<String> resetPortletInvocationWhitelistActions() {
        this._portletInvocationWhitelistActions = SetUtil.fromArray(this.getWhitelistActionsPropsValues());
        this._portletInvocationWhitelistActions = this._portletInvocationWhitelistActions.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(this._portletInvocationWhitelistActions);
        return this._portletInvocationWhitelistActions;
    }

    protected boolean isValidStrutsAction(long companyId, String portletId, String strutsAction) {
        block4: {
            try {
                Portlet portlet = PortletLocalServiceUtil.getPortletById(companyId, portletId);
                if (portlet == null) {
                    return false;
                }
                String strutsPath = strutsAction.substring(1, strutsAction.lastIndexOf(47));
                if (strutsPath.equals(portlet.getStrutsPath()) || strutsPath.equals(portlet.getParentStrutsPath())) {
                    return true;
                }
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug(exception, exception);
            }
        }
        return false;
    }
}

