/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.security.auth;

import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.petra.lang.SafeClosable;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.TimeZoneThreadLocal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Locale;
import java.util.TimeZone;

public class CompanyThreadLocal {
    private static final Log _log = LogFactoryUtil.getLog(CompanyThreadLocal.class);
    private static final CentralizedThreadLocal<Long> _companyId = new CentralizedThreadLocal(CompanyThreadLocal.class + "._companyId", () -> 0L);
    private static final ThreadLocal<Boolean> _deleteInProcess = new CentralizedThreadLocal(CompanyThreadLocal.class + "._deleteInProcess", () -> Boolean.FALSE);
    private static final ThreadLocal<Boolean> _locked = new CentralizedThreadLocal(CompanyThreadLocal.class + "._locked", () -> Boolean.FALSE);

    public static Long getCompanyId() {
        Long companyId = (Long)_companyId.get();
        if (_log.isDebugEnabled()) {
            _log.debug("getCompanyId " + companyId);
        }
        return companyId;
    }

    public static boolean isDeleteInProcess() {
        return _deleteInProcess.get();
    }

    public static boolean isLocked() {
        return _locked.get();
    }

    public static SafeCloseable lock(long companyId) {
        SafeCloseable safeCloseable = CompanyThreadLocal.setWithSafeCloseable(companyId);
        _locked.set(true);
        return () -> {
            _locked.set(false);
            safeCloseable.close();
        };
    }

    public static void setCompanyId(Long companyId) {
        if (CompanyThreadLocal._setCompanyId(companyId)) {
            CTCollectionThreadLocal.removeCTCollectionId();
        }
    }

    public static void setDeleteInProcess(boolean deleteInProcess) {
        _deleteInProcess.set(deleteInProcess);
    }

    @Deprecated
    public static SafeClosable setInitializingCompanyId(long companyId) {
        if (companyId > 0L) {
            return _companyId.setWithSafeClosable((Object)companyId);
        }
        return _companyId.setWithSafeClosable((Object)0L);
    }

    public static SafeCloseable setInitializingCompanyIdWithSafeCloseable(long companyId) {
        if (companyId > 0L) {
            return _companyId.setWithSafeCloseable((Object)companyId);
        }
        return _companyId.setWithSafeCloseable((Object)0L);
    }

    @Deprecated
    public static SafeClosable setWithSafeClosable(Long companyId) {
        long currentCompanyId = (Long)_companyId.get();
        Locale defaultLocale = LocaleThreadLocal.getDefaultLocale();
        TimeZone defaultTimeZone = TimeZoneThreadLocal.getDefaultTimeZone();
        CompanyThreadLocal._setCompanyId(companyId);
        SafeClosable ctCollectionSafeClosable = CTCollectionThreadLocal.setCTCollectionId(0L);
        return () -> {
            _companyId.set((Object)currentCompanyId);
            LocaleThreadLocal.setDefaultLocale(defaultLocale);
            TimeZoneThreadLocal.setDefaultTimeZone(defaultTimeZone);
            ctCollectionSafeClosable.close();
        };
    }

    public static SafeCloseable setWithSafeCloseable(Long companyId) {
        long currentCompanyId = (Long)_companyId.get();
        Locale defaultLocale = LocaleThreadLocal.getDefaultLocale();
        TimeZone defaultTimeZone = TimeZoneThreadLocal.getDefaultTimeZone();
        CompanyThreadLocal._setCompanyId(companyId);
        SafeCloseable ctCollectionSafeCloseable = CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable(0L);
        return () -> {
            _companyId.set((Object)currentCompanyId);
            LocaleThreadLocal.setDefaultLocale(defaultLocale);
            TimeZoneThreadLocal.setDefaultTimeZone(defaultTimeZone);
            ctCollectionSafeCloseable.close();
        };
    }

    private static User _fetchDefaultUser(long companyId) throws Exception {
        User defaultUser;
        block49: {
            defaultUser = null;
            try {
                defaultUser = UserLocalServiceUtil.fetchDefaultUser(companyId);
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block49;
                _log.debug(exception, exception);
            }
        }
        if (defaultUser != null) {
            return defaultUser;
        }
        try (Connection connection = DataAccess.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("select userId, languageId, timeZoneId from User_ where companyId = ? and defaultUser = ?");){
            preparedStatement.setLong(1, companyId);
            preparedStatement.setBoolean(2, true);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (!resultSet.next()) {
                    User user = null;
                    return user;
                }
                defaultUser = UserLocalServiceUtil.createUser(resultSet.getLong("userId"));
                defaultUser.setLanguageId(resultSet.getString("languageId"));
                defaultUser.setTimeZoneId(resultSet.getString("timeZoneId"));
            }
        }
        return defaultUser;
    }

    private static boolean _setCompanyId(Long companyId) {
        block9: {
            if (companyId.equals(_companyId.get())) {
                return false;
            }
            if (CompanyThreadLocal.isLocked()) {
                throw new UnsupportedOperationException("CompanyThreadLocal modification is not allowed");
            }
            if (_log.isDebugEnabled()) {
                _log.debug("setCompanyId " + companyId);
            }
            if (companyId > 0L) {
                _companyId.set((Object)companyId);
                try {
                    User defaultUser = CompanyThreadLocal._fetchDefaultUser(companyId);
                    if (defaultUser == null) {
                        if (_log.isWarnEnabled()) {
                            _log.warn("No default user was found for company " + companyId);
                        }
                        break block9;
                    }
                    LocaleThreadLocal.setDefaultLocale(defaultUser.getLocale());
                    TimeZoneThreadLocal.setDefaultTimeZone(defaultUser.getTimeZone());
                }
                catch (Exception exception) {
                    _log.error(exception, exception);
                }
            } else {
                _companyId.set((Object)0L);
                LocaleThreadLocal.setDefaultLocale(null);
                TimeZoneThreadLocal.setDefaultTimeZone(null);
            }
        }
        return true;
    }
}

