/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.security.auth;

import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;

public class PrincipalThreadLocal {
    private static final Log _log = LogFactoryUtil.getLog(PrincipalThreadLocal.class);
    private static final ThreadLocal<String> _name = new CentralizedThreadLocal(PrincipalThreadLocal.class + "._name");
    private static final ThreadLocal<String> _password = new CentralizedThreadLocal(PrincipalThreadLocal.class + "._password");

    public static String getName() {
        String name = _name.get();
        if (_log.isDebugEnabled()) {
            _log.debug("getName " + name);
        }
        return name;
    }

    public static String getPassword() {
        return _password.get();
    }

    public static long getUserId() {
        return GetterUtil.getLong(PrincipalThreadLocal.getName());
    }

    public static void setName(long name) {
        PrincipalThreadLocal.setName(String.valueOf(name));
    }

    public static void setName(String name) {
        if (_log.isDebugEnabled()) {
            _log.debug("setName " + name);
        }
        _name.set(name);
        CTCollectionThreadLocal.removeCTCollectionId();
    }

    public static void setPassword(String password) {
        _password.set(password);
    }
}

