/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.security.membershippolicy;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.security.membershippolicy.UserGroupMembershipPolicy;
import com.liferay.portal.kernel.service.UserGroupLocalServiceUtil;

public abstract class BaseUserGroupMembershipPolicy
implements UserGroupMembershipPolicy {
    private static final Log _log = LogFactoryUtil.getLog(BaseUserGroupMembershipPolicy.class);

    @Override
    public boolean isMembershipAllowed(long userId, long userGroupId) throws PortalException {
        try {
            this.checkMembership(new long[]{userId}, new long[]{userGroupId}, null);
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug(exception, exception);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isMembershipRequired(long userId, long userGroupId) throws PortalException {
        try {
            this.checkMembership(new long[]{userId}, null, new long[]{userGroupId});
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug(exception, exception);
            }
            return true;
        }
        return false;
    }

    @Override
    public void verifyPolicy() throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = UserGroupLocalServiceUtil.getActionableDynamicQuery();
        actionableDynamicQuery.setPerformActionMethod(userGroup -> this.verifyPolicy((UserGroup)userGroup));
        actionableDynamicQuery.performActions();
    }

    @Override
    public void verifyPolicy(UserGroup userGroup) throws PortalException {
        this.verifyPolicy(userGroup, null, null);
    }
}

