/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.NonSerializableObjectHandler;
import com.liferay.portal.kernel.servlet.PersistentHttpServletRequestWrapper;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import java.lang.reflect.Field;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class NonSerializableObjectRequestWrapper
extends PersistentHttpServletRequestWrapper {
    private static final boolean _WEBLOGIC_REQUEST_WRAP_NON_SERIALIZABLE = GetterUtil.getBoolean(PropsUtil.get("weblogic.request.wrap.non.serializable"));
    private static final Log _log = LogFactoryUtil.getLog(NonSerializableObjectRequestWrapper.class);

    public static boolean isWrapped(HttpServletRequest httpServletRequest) {
        if (!_WEBLOGIC_REQUEST_WRAP_NON_SERIALIZABLE) {
            return false;
        }
        Class<?> clazz = httpServletRequest.getClass();
        String className = clazz.getName();
        if (className.startsWith("weblogic.")) {
            httpServletRequest.removeAttribute(NonSerializableObjectRequestWrapper.class.getName());
            return false;
        }
        Boolean wrapped = (Boolean)httpServletRequest.getAttribute(NonSerializableObjectRequestWrapper.class.getName());
        if (wrapped == null) {
            return false;
        }
        return wrapped;
    }

    public NonSerializableObjectRequestWrapper(HttpServletRequest httpServletRequest) {
        super(httpServletRequest);
        httpServletRequest.setAttribute(NonSerializableObjectRequestWrapper.class.getName(), (Object)Boolean.TRUE);
    }

    public Object getAttribute(String name) {
        Object object = null;
        try {
            object = super.getAttribute(name);
        }
        catch (Exception exception) {
            String message = exception.getMessage();
            if (message == null || !message.contains("BEA-101362")) {
                _log.error(exception, exception);
            }
            return null;
        }
        return NonSerializableObjectHandler.getValue(object);
    }

    public void setAttribute(String name, Object object) {
        if (_WEBLOGIC_REQUEST_WRAP_NON_SERIALIZABLE && !(object instanceof NonSerializableObjectHandler)) {
            object = new NonSerializableObjectHandler(object);
        }
        super.setAttribute(name, object);
        this._setWebLogicClassLoaderFlag(name);
    }

    private void _setWebLogicClassLoaderFlag(String attributeName) {
        block4: {
            ServletRequest servletRequest = this.getRequest();
            try {
                Field servletRequestAttributesField = ReflectionUtil.getDeclaredField(servletRequest.getClass(), (String)"attributes");
                Object servletRequestAttributes = servletRequestAttributesField.get(servletRequest);
                Field attributesField = ReflectionUtil.getDeclaredField(servletRequestAttributes.getClass(), (String)"attributes");
                Map map = (Map)attributesField.get(servletRequestAttributes);
                Object attribute = map.get(attributeName);
                Field isWebLogicClassLoaderField = ReflectionUtil.getDeclaredField(attribute.getClass(), (String)"isWebLogicClassLoader");
                isWebLogicClassLoaderField.set(attribute, false);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Unable to get fields from a Weblogic servlet request", noSuchFieldException);
                }
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug(StringBundler.concat((Object[])new Object[]{"Unable to set WebLogic class loader flag for ", "attribute ", attributeName, " in servlet request ", servletRequest}), exception);
            }
        }
    }
}

