/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletApp;
import com.liferay.portal.kernel.servlet.PortalWebResourcesUtil;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;

public class PortletResourcesUtil {
    private static final Log _log = LogFactoryUtil.getLog(PortletResourcesUtil.class);
    private static final PortletResourcesUtil _portletResourcesUtil = new PortletResourcesUtil();
    private final ServiceTracker<Portlet, Portlet> _serviceTracker;
    private final Map<ServiceReference<Portlet>, ServletContext> _servletContexts = new ConcurrentHashMap<ServiceReference<Portlet>, ServletContext>();

    public static ServletContext getPathServletContext(String path) {
        for (ServletContext servletContext : PortletResourcesUtil._portletResourcesUtil._servletContexts.values()) {
            if (!path.startsWith(servletContext.getContextPath())) continue;
            return servletContext;
        }
        return null;
    }

    public static URL getResource(ServletContext servletContext, String path) {
        block4: {
            if (servletContext == null) {
                return null;
            }
            path = PortalWebResourcesUtil.stripContextPath(servletContext, path);
            try {
                URL url = servletContext.getResource(path);
                if (url != null) {
                    return url;
                }
            }
            catch (MalformedURLException malformedURLException) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug(malformedURLException, malformedURLException);
            }
        }
        return null;
    }

    public static URL getResource(String path) {
        ServletContext servletContext = PortletResourcesUtil.getPathServletContext(path);
        if (servletContext != null) {
            return PortletResourcesUtil.getResource(servletContext, path);
        }
        return null;
    }

    private PortletResourcesUtil() {
        Registry registry = RegistryUtil.getRegistry();
        this._serviceTracker = registry.trackServices(Portlet.class, (ServiceTrackerCustomizer)new PortletResourcesServiceTrackerCustomizer());
        this._serviceTracker.open();
    }

    private class PortletResourcesServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<Portlet, Portlet> {
        private PortletResourcesServiceTrackerCustomizer() {
        }

        public Portlet addingService(ServiceReference<Portlet> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            Portlet portlet = (Portlet)registry.getService(serviceReference);
            PortletApp portletApp = portlet.getPortletApp();
            if (portletApp.isWARFile()) {
                PortletResourcesUtil.this._servletContexts.put(serviceReference, portletApp.getServletContext());
            }
            return portlet;
        }

        public void modifiedService(ServiceReference<Portlet> serviceReference, Portlet portlet) {
        }

        public void removedService(ServiceReference<Portlet> serviceReference, Portlet portlet) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            PortletResourcesUtil.this._servletContexts.remove(serviceReference);
        }
    }
}

