/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet.taglib.aui;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.servlet.taglib.aui.TagInvocationData;
import com.liferay.portal.kernel.servlet.taglib.aui.VariableUtil;
import com.liferay.portal.kernel.util.Mergeable;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ScriptData
implements Mergeable<ScriptData>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ConcurrentMap<String, PortletData> _portletDataMap = new ConcurrentHashMap<String, PortletData>();

    @Deprecated
    public void append(String portletId, com.liferay.portal.kernel.util.StringBundler contentSB, String modules, ModulesType modulesType) {
        PortletData portletData = this._getPortletData(portletId);
        StringBundler sb = new StringBundler();
        for (int i = 0; i < contentSB.index(); ++i) {
            sb.append(contentSB.stringAt(0));
        }
        portletData.append(sb, modules, modulesType);
    }

    public void append(String portletId, String content, String modules, ModulesType modulesType) {
        PortletData portletData = this._getPortletData(portletId);
        portletData.append(content, modules, modulesType);
    }

    public void append(String portletId, StringBundler contentSB, String modules, ModulesType modulesType) {
        PortletData portletData = this._getPortletData(portletId);
        portletData.append(contentSB, modules, modulesType);
    }

    public void mark() {
        for (PortletData portletData : this._portletDataMap.values()) {
            portletData.mark();
        }
    }

    @Override
    public ScriptData merge(ScriptData scriptData) {
        if (scriptData != null && scriptData != this) {
            this._portletDataMap.putAll(scriptData._portletDataMap);
        }
        return this;
    }

    public void reset() {
        for (PortletData portletData : this._portletDataMap.values()) {
            portletData.reset();
        }
    }

    @Override
    public ScriptData split() {
        return new ScriptData();
    }

    public void writeTo(Writer writer) throws IOException {
        writer.write("<script type=\"text/javascript\">\n// <![CDATA[\n");
        for (PortletData portletData : this._portletDataMap.values()) {
            portletData._rawSB.writeTo(writer);
        }
        Collection<PortletData> portletDataCollection = this._portletDataMap.values();
        this._writeEs6ModulesTo(writer, portletDataCollection);
        this._writeAuiModulesTo(writer, portletDataCollection);
        writer.write("\n// ]]>\n</script>");
    }

    public void writeTo(Writer writer, String portletId) throws IOException {
        PortletData portletData = (PortletData)this._portletDataMap.remove(portletId);
        if (portletData == null) {
            return;
        }
        writer.write("<script type=\"text/javascript\">\n// <![CDATA[\n");
        portletData._rawSB.writeTo(writer);
        Set<PortletData> portletDataCollection = Collections.singleton(portletData);
        if (!portletData._es6TagInvocationDatas.isEmpty()) {
            this._writeEs6ModulesTo(writer, portletDataCollection);
        }
        if (!portletData._auiModulesSet.isEmpty()) {
            this._writeAuiModulesTo(writer, portletDataCollection);
        }
        writer.write("\n// ]]>\n</script>");
    }

    private PortletData _getPortletData(String portletId) {
        PortletData oldPortletData;
        PortletData portletData;
        if (Validator.isNull(portletId)) {
            portletId = "";
        }
        if ((portletData = (PortletData)this._portletDataMap.get(portletId)) == null && (oldPortletData = this._portletDataMap.putIfAbsent(portletId, portletData = new PortletData())) != null) {
            portletData = oldPortletData;
        }
        return portletData;
    }

    private void _writeAuiModulesTo(Writer writer, Collection<PortletData> portletDataCollection) throws IOException {
        StringBundler auiModulesSB = new StringBundler(portletDataCollection.size());
        HashSet auiModulesSet = new HashSet();
        for (PortletData portletData : portletDataCollection) {
            if (portletData._auiModulesSet.isEmpty()) continue;
            auiModulesSB.append(portletData._auiCallbackSB);
            auiModulesSet.addAll(portletData._auiModulesSet);
        }
        if (!auiModulesSet.isEmpty()) {
            writer.write("AUI().use(");
            for (String use : auiModulesSet) {
                writer.write("'");
                writer.write(use);
                writer.write("'");
                writer.write(", ");
            }
            writer.write("function(A) {");
            auiModulesSB.writeTo(writer);
            writer.write("});");
        }
    }

    private void _writeEs6ModulesTo(Writer writer, Collection<PortletData> portletDataCollection) throws IOException {
        StringBundler es6CallbacksSB = new StringBundler(portletDataCollection.size());
        ArrayList<String> es6Modules = new ArrayList<String>();
        ArrayList<String> es6Variables = new ArrayList<String>();
        HashSet usedVariables = new HashSet();
        for (PortletData portletData : portletDataCollection) {
            if (portletData._es6TagInvocationDatas.isEmpty()) continue;
            for (TagInvocationData tagInvocationData : portletData._es6TagInvocationDatas) {
                List<String> modules = tagInvocationData.getModules();
                Stream stream = modules.stream();
                List<String> variables = stream.map(module -> VariableUtil.generateVariable(module, usedVariables)).collect(Collectors.toList());
                es6Modules.addAll(modules);
                es6Variables.addAll(variables);
                es6CallbacksSB.append(tagInvocationData.getContent(variables));
                es6CallbacksSB.append("\n");
            }
        }
        if (es6Modules.isEmpty()) {
            return;
        }
        writer.write("Liferay.Loader.require(");
        for (String es6Module : es6Modules) {
            writer.write("'");
            writer.write(es6Module);
            writer.write("'");
            writer.write(", ");
        }
        writer.write("function(");
        String delimiter = "";
        for (String es6Variable : es6Variables) {
            writer.write(delimiter);
            writer.write(es6Variable);
            delimiter = ", ";
        }
        writer.write(") {\n");
        writer.write("try {\n");
        es6CallbacksSB.writeTo(writer);
        writer.write("} catch (err) {\n");
        writer.write("\tconsole.error(err);\n");
        writer.write("}\n");
        writer.write("});");
    }

    private static class PortletData
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final StringBundler _auiCallbackSB = new StringBundler();
        private int _auiCallbackSBIndex = -1;
        private final Set<String> _auiModulesSet = new HashSet<String>();
        private List<TagInvocationData> _es6TagInvocationDatas = new ArrayList<TagInvocationData>();
        private int _es6TagInvocationDatasIndex = -1;
        private final StringBundler _rawSB = new StringBundler();
        private int _rawSBIndex = -1;

        private PortletData() {
        }

        public void append(String content, String modules, ModulesType modulesType) {
            if (Validator.isNull(modules)) {
                this._rawSB.append(content);
            } else {
                String[] modulesArray = StringUtil.split(modules);
                if (modulesType == ModulesType.AUI) {
                    this._auiCallbackSB.append("(function() {");
                    this._auiCallbackSB.append(content);
                    this._auiCallbackSB.append("})();");
                    for (String module : modulesArray) {
                        this._auiModulesSet.add(StringUtil.trim(module));
                    }
                } else {
                    this._es6TagInvocationDatas.add(new TagInvocationData(content, modules));
                }
            }
        }

        public void append(StringBundler contentSB, String modules, ModulesType modulesType) {
            if (Validator.isNull(modules)) {
                this._rawSB.append(contentSB);
            } else {
                String[] modulesArray = StringUtil.split(modules);
                if (modulesType == ModulesType.AUI) {
                    this._auiCallbackSB.append("(function() {");
                    this._auiCallbackSB.append(contentSB);
                    this._auiCallbackSB.append("})();");
                    for (String module : modulesArray) {
                        this._auiModulesSet.add(StringUtil.trim(module));
                    }
                } else {
                    this._es6TagInvocationDatas.add(new TagInvocationData(contentSB, modules));
                }
            }
        }

        public void mark() {
            this._auiCallbackSBIndex = this._auiCallbackSB.index();
            this._es6TagInvocationDatasIndex = this._es6TagInvocationDatas.size();
            this._rawSBIndex = this._rawSB.index();
        }

        public void reset() {
            if (this._auiCallbackSBIndex >= 0) {
                this._auiCallbackSB.setIndex(this._auiCallbackSBIndex);
            }
            if (this._es6TagInvocationDatasIndex >= 0) {
                this._es6TagInvocationDatas = this._es6TagInvocationDatas.subList(0, this._es6TagInvocationDatasIndex);
            }
            if (this._rawSBIndex >= 0) {
                this._rawSB.setIndex(this._rawSBIndex);
            }
        }
    }

    public static enum ModulesType {
        AUI,
        ES6;

    }
}

