/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.upgrade;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBInspector;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;

public abstract class BaseDBColumnSizeUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(BaseDBColumnSizeUpgradeProcess.class);
    private final DBType _dbType;
    private final String _oldColumnType;
    private final int _size;

    public BaseDBColumnSizeUpgradeProcess(DBType dbType, String oldColumnType, int size) {
        this._dbType = dbType;
        this._oldColumnType = oldColumnType;
        this._size = size;
    }

    @Override
    protected void doUpgrade() throws Exception {
        DB db = DBManagerUtil.getDB();
        if (db.getDBType() == this._dbType) {
            this._upgradeTables();
        }
    }

    protected abstract void upgradeColumn(String var1, String var2) throws Exception;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _upgradeTables() throws Exception {
        DatabaseMetaData databaseMetaData = this.connection.getMetaData();
        DBInspector dbInspector = new DBInspector(this.connection);
        String catalog = dbInspector.getCatalog();
        String schema = dbInspector.getSchema();
        try (LoggingTimer loggingTimer = new LoggingTimer();
             ResultSet tableResultSet = databaseMetaData.getTables(catalog, schema, null, new String[]{"TABLE"});){
            while (tableResultSet.next()) {
                ResultSet columnResultSet;
                block65: {
                    String tableName = dbInspector.normalizeName(tableResultSet.getString("TABLE_NAME"));
                    HashSet<String> invalidColumnNames = new HashSet<String>();
                    try (ResultSet primaryKeyResultSet = databaseMetaData.getPrimaryKeys(catalog, schema, tableName);){
                        while (primaryKeyResultSet.next()) {
                            String primaryKeyName = StringUtil.toUpperCase(primaryKeyResultSet.getString("COLUMN_NAME"));
                            invalidColumnNames.add(primaryKeyName);
                        }
                    }
                    var12_16 = null;
                    try (ResultSet indexResultSet = databaseMetaData.getIndexInfo(catalog, schema, tableName, false, false);){
                        while (indexResultSet.next()) {
                            invalidColumnNames.add(StringUtil.toUpperCase(indexResultSet.getString("COLUMN_NAME")));
                        }
                    }
                    catch (Throwable primaryKeyName) {
                        var12_16 = primaryKeyName;
                        throw primaryKeyName;
                    }
                    columnResultSet = databaseMetaData.getColumns(catalog, schema, tableName, null);
                    var12_16 = null;
                    try {
                        while (columnResultSet.next()) {
                            String columnName;
                            int size = columnResultSet.getInt("COLUMN_SIZE");
                            if (size != this._size || !StringUtil.equalsIgnoreCase(this._oldColumnType, columnResultSet.getString("TYPE_NAME")) || invalidColumnNames.contains(StringUtil.toUpperCase(columnName = columnResultSet.getString("COLUMN_NAME")))) continue;
                            try {
                                this.upgradeColumn(tableName, columnName);
                            }
                            catch (SQLException sqlException) {
                                if (!_log.isWarnEnabled()) continue;
                                _log.warn(StringBundler.concat((String[])new String[]{"Unable to alter length of column ", columnName, " for table ", tableName}), sqlException);
                            }
                        }
                        if (columnResultSet == null) continue;
                        if (var12_16 == null) break block65;
                    }
                    catch (Throwable throwable) {
                        try {
                            var12_16 = throwable;
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            if (columnResultSet == null) throw throwable2;
                            if (var12_16 != null) {
                                try {
                                    columnResultSet.close();
                                    throw throwable2;
                                }
                                catch (Throwable throwable3) {
                                    var12_16.addSuppressed(throwable3);
                                    throw throwable2;
                                }
                            }
                            columnResultSet.close();
                            throw throwable2;
                        }
                    }
                    try {
                        columnResultSet.close();
                        continue;
                    }
                    catch (Throwable throwable) {
                        var12_16.addSuppressed(throwable);
                        continue;
                    }
                }
                columnResultSet.close();
            }
            return;
        }
    }
}

