/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.upgrade;

import com.liferay.layout.admin.kernel.model.LayoutTypePortletConstants;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.model.PortletPreferenceValue;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;

public abstract class BasePortletIdUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(BasePortletIdUpgradeProcess.class);

    @Override
    protected void doUpgrade() throws Exception {
        this.upgradeInstanceablePortletIds();
        this.upgradeUninstanceablePortletIds();
    }

    protected String getNewTypeSettings(String typeSettings, String oldPropertyId, String newPropertyId) {
        UnicodeProperties typeSettingsUnicodeProperties = new UnicodeProperties(true);
        typeSettingsUnicodeProperties.fastLoad(typeSettings);
        String value = typeSettingsUnicodeProperties.remove(oldPropertyId);
        if (value != null) {
            typeSettingsUnicodeProperties.setProperty(newPropertyId, value);
        }
        return typeSettingsUnicodeProperties.toString();
    }

    protected String getNewTypeSettings(String typeSettings, String oldRootPortletId, String newRootPortletId, boolean exactMatch) {
        UnicodeProperties typeSettingsUnicodeProperties = new UnicodeProperties(true);
        typeSettingsUnicodeProperties.fastLoad(typeSettings);
        for (Map.Entry entry : typeSettingsUnicodeProperties.entrySet()) {
            String typeSettingId = (String)entry.getKey();
            if (!LayoutTypePortletConstants.hasPortletIds(typeSettingId)) continue;
            Object[] portletIds = StringUtil.split((String)entry.getValue());
            for (int j = 0; j < portletIds.length; ++j) {
                Object portletId = portletIds[j];
                if (exactMatch) {
                    if (!((String)portletId).equals(oldRootPortletId)) continue;
                    portletIds[j] = newRootPortletId;
                    continue;
                }
                String rootPortletId = PortletIdCodec.decodePortletName((String)portletId);
                if (!rootPortletId.equals(oldRootPortletId)) continue;
                long userId = PortletIdCodec.decodeUserId((String)portletId);
                String instanceId = PortletIdCodec.decodeInstanceId((String)portletId);
                portletIds[j] = PortletIdCodec.encode(newRootPortletId, userId, instanceId);
            }
            String portletIdsString = StringUtil.merge(portletIds);
            typeSettingsUnicodeProperties.setProperty(typeSettingId, portletIdsString);
        }
        return typeSettingsUnicodeProperties.toString();
    }

    protected String[][] getRenamePortletIdsArray() {
        return new String[0][0];
    }

    protected String getTypeSettingsCriteria(String portletId) {
        StringBundler sb = new StringBundler(21);
        sb.append("typeSettings like '%=");
        sb.append(portletId);
        sb.append(",%' OR typeSettings like '%=");
        sb.append(portletId);
        sb.append("\n%' OR typeSettings like '%=");
        sb.append(portletId);
        sb.append("' OR typeSettings like '%,");
        sb.append(portletId);
        sb.append(",%' OR typeSettings like '%,");
        sb.append(portletId);
        sb.append("\n%' OR typeSettings like '%,");
        sb.append(portletId);
        sb.append("' OR typeSettings like '%=");
        sb.append(portletId);
        sb.append("_INSTANCE_%' OR typeSettings like '%,");
        sb.append(portletId);
        sb.append("_INSTANCE_%' OR typeSettings like '%=");
        sb.append(portletId);
        sb.append("_USER_%' OR typeSettings like '%,");
        sb.append(portletId);
        sb.append("_USER_%'");
        return sb.toString();
    }

    protected String[] getUninstanceablePortletIds() {
        return new String[0];
    }

    @Deprecated
    protected void updateGroup(long groupId, String typeSettings) throws Exception {
        block14: {
            String sql = "update Group_ set typeSettings = ? where groupId = " + groupId;
            try (PreparedStatement preparedStatement = this.connection.prepareStatement(sql);){
                preparedStatement.setString(1, typeSettings);
                preparedStatement.executeUpdate();
            }
            catch (SQLException sqlException) {
                if (!_log.isWarnEnabled()) break block14;
                _log.warn(sqlException, sqlException);
            }
        }
    }

    protected void updateGroup(String oldRootPortletId, String newRootPortletId) throws Exception {
        String oldStagedPortletId = this._getStagedPortletId(oldRootPortletId);
        String sql1 = StringBundler.concat((String[])new String[]{"select groupId, typeSettings from Group_ where typeSettings like ", "'%", oldStagedPortletId, "%'"});
        String sql2 = "update Group_ set typeSettings = ? where groupId = ?";
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(sql1);
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch(this.connection, sql2);
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                String newTypeSettings;
                String typeSettings = resultSet.getString("typeSettings");
                if (Objects.equals(typeSettings, newTypeSettings = this.getNewTypeSettings(typeSettings, oldStagedPortletId, this._getStagedPortletId(newRootPortletId)))) continue;
                preparedStatement2.setString(1, newTypeSettings);
                preparedStatement2.setLong(2, resultSet.getLong("groupId"));
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }

    protected void updateInstanceablePortletPreferences(String oldRootPortletId, String newRootPortletId) throws Exception {
        this.runSQL(StringBundler.concat((String[])new String[]{"update PortletPreferences set portletId = '", newRootPortletId, "' where portletId = '", oldRootPortletId, "'"}));
        if (!newRootPortletId.contains("_INSTANCE_")) {
            this.runSQL(StringBundler.concat((String[])new String[]{"update PortletPreferences set portletId = replace(", "portletId, '", oldRootPortletId, "_INSTANCE_', '", newRootPortletId, "_INSTANCE_') where portletId like '", oldRootPortletId, "_INSTANCE_%'"}));
        }
        this.runSQL(StringBundler.concat((String[])new String[]{"update PortletPreferences set portletId = replace(portletId, ", "'", oldRootPortletId, "_USER_', '", newRootPortletId, "_USER_') where portletId like '", oldRootPortletId, "_USER_%'"}));
        if (this.hasColumn("PortletPreferences", "preferences")) {
            DB db = DBManagerUtil.getDB();
            DBType dbType = db.getDBType();
            String preferencesExpression = "preferences";
            if (dbType == DBType.SYBASE) {
                preferencesExpression = "CAST_TEXT(preferences)";
            }
            this.runSQL(StringBundler.concat((String[])new String[]{"update PortletPreferences set preferences = replace(", preferencesExpression, ", '#p_p_id_", oldRootPortletId, "', '#p_p_id_", newRootPortletId, "') where portletId = '", newRootPortletId, "'"}));
            this.runSQL(StringBundler.concat((String[])new String[]{"update PortletPreferences set preferences = replace(", preferencesExpression, ", '#portlet_", oldRootPortletId, "', '#portlet_", newRootPortletId, "') where portletId = '", newRootPortletId, "'"}));
            if (!newRootPortletId.contains("_INSTANCE_")) {
                this.runSQL(StringBundler.concat((String[])new String[]{"update PortletPreferences set preferences = replace(", preferencesExpression, ", '#p_p_id_", oldRootPortletId, "_INSTANCE_', '#p_p_id_", newRootPortletId, "_INSTANCE_') where portletId like '", newRootPortletId, "_INSTANCE_%'"}));
                this.runSQL(StringBundler.concat((String[])new String[]{"update PortletPreferences set preferences = replace(", preferencesExpression, ", '#portlet_", oldRootPortletId, "_INSTANCE_', '#portlet_", newRootPortletId, "_INSTANCE_') where portletId like '", newRootPortletId, "_INSTANCE_%'"}));
            }
            this.runSQL(StringBundler.concat((String[])new String[]{"update PortletPreferences set preferences = replace(", preferencesExpression, ", '#p_p_id_", oldRootPortletId, "_USER_', '#p_p_id_", newRootPortletId, "_USER_') where portletId like '", newRootPortletId, "_USER_%'"}));
            this.runSQL(StringBundler.concat((String[])new String[]{"update PortletPreferences set preferences = replace(", preferencesExpression, ", '#portlet_", oldRootPortletId, "_USER_', '#portlet_", newRootPortletId, "_USER_') where portletId like '", newRootPortletId, "_USER_%'"}));
        } else {
            int smallValueMaxLength = ModelHintsUtil.getMaxLength(PortletPreferenceValue.class.getName(), "smallValue");
            String selectSQL = StringBundler.concat((String[])new String[]{"select PortletPreferenceValue.portletPreferenceValueId, ", "PortletPreferenceValue.largeValue, ", "PortletPreferenceValue.smallValue from ", "PortletPreferenceValue inner join PortletPreferences on ", "PortletPreferences.portletPreferencesId = ", "PortletPreferenceValue.portletPreferencesId where ", "(PortletPreferences.portletId = '", newRootPortletId, "' or PortletPreferences.portletId like '", newRootPortletId, "_INSTANCE_%' or PortletPreferences.portletId like '", newRootPortletId, "_USER_%') and PortletPreferenceValue.name ", "= 'portletSetupCss'"});
            String updateSQL = "update PortletPreferenceValue set largeValue = ?, smallValue = ? where portletPreferenceValueId = ?";
            try (PreparedStatement selectPreparedStatement = this.connection.prepareStatement(selectSQL);
                 PreparedStatement updatePreparedStatement = AutoBatchPreparedStatementUtil.autoBatch(this.connection.prepareStatement(updateSQL));
                 ResultSet resultSet = selectPreparedStatement.executeQuery();){
                while (resultSet.next()) {
                    String newValue;
                    String value = resultSet.getString("smallValue");
                    if (Validator.isBlank(value)) {
                        value = resultSet.getString("largeValue");
                    }
                    if (Objects.equals(value, newValue = StringUtil.replace(value, new String[]{"#p_p_id_" + oldRootPortletId, "#portlet_" + oldRootPortletId}, new String[]{"#p_p_id_" + newRootPortletId, "#portlet_" + newRootPortletId}))) continue;
                    String largeValue = null;
                    String smallValue = null;
                    if (newValue.length() > smallValueMaxLength) {
                        largeValue = newValue;
                    } else {
                        smallValue = newValue;
                    }
                    updatePreparedStatement.setString(1, largeValue);
                    updatePreparedStatement.setString(2, smallValue);
                    updatePreparedStatement.setLong(3, resultSet.getLong("portletPreferenceValueId"));
                    updatePreparedStatement.addBatch();
                }
                updatePreparedStatement.executeBatch();
            }
        }
    }

    protected void updateLayout(long plid, String typeSettings) throws Exception {
        block14: {
            try (PreparedStatement preparedStatement = this.connection.prepareStatement("update Layout set typeSettings = ? where plid = " + plid);){
                preparedStatement.setString(1, typeSettings);
                preparedStatement.executeUpdate();
            }
            catch (SQLException sqlException) {
                if (!_log.isWarnEnabled()) break block14;
                _log.warn(sqlException, sqlException);
            }
        }
    }

    protected void updateLayout(long plid, String oldPortletId, String newPortletId) throws Exception {
        block27: {
            try (PreparedStatement preparedStatement = this.connection.prepareStatement("select typeSettings from Layout where plid = " + plid);
                 ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    String newTypeSettings;
                    String typeSettings = resultSet.getString("typeSettings");
                    if (Objects.equals(typeSettings, newTypeSettings = StringUtil.replace(typeSettings, oldPortletId, newPortletId))) continue;
                    this.updateLayout(plid, newTypeSettings);
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block27;
                _log.warn(exception, exception);
            }
        }
    }

    protected void updateLayoutRevision(long layoutRevisionId, String typeSettings) throws Exception {
        block14: {
            String sql = "update LayoutRevision set typeSettings = ? where layoutRevisionId = " + layoutRevisionId;
            try (PreparedStatement preparedStatement = this.connection.prepareStatement(sql);){
                preparedStatement.setString(1, typeSettings);
                preparedStatement.executeUpdate();
            }
            catch (SQLException sqlException) {
                if (!_log.isWarnEnabled()) break block14;
                _log.warn(sqlException, sqlException);
            }
        }
    }

    protected void updateLayoutRevisions(String oldRootPortletId, String newRootPortletId, boolean exactMatch) throws Exception {
        String sql1 = "select layoutRevisionId, typeSettings from LayoutRevision where " + this.getTypeSettingsCriteria(oldRootPortletId);
        String sql2 = "update LayoutRevision set typeSettings = ? where layoutRevisionId = ?";
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(sql1);
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch(this.connection, sql2);
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                String newTypeSettings;
                String typeSettings = resultSet.getString("typeSettings");
                if (Objects.equals(typeSettings, newTypeSettings = this.getNewTypeSettings(typeSettings, oldRootPortletId, newRootPortletId, exactMatch))) continue;
                preparedStatement2.setString(1, newTypeSettings);
                preparedStatement2.setLong(2, resultSet.getLong("layoutRevisionId"));
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }

    protected void updateLayouts(String oldRootPortletId, String newRootPortletId, boolean exactMatch) throws Exception {
        String sql1 = "select plid, typeSettings from Layout where " + this.getTypeSettingsCriteria(oldRootPortletId);
        String sql2 = "update Layout set typeSettings = ? where plid = ?";
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(sql1);
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch(this.connection, sql2);
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                String newTypeSettings;
                String typeSettings = resultSet.getString("typeSettings");
                if (Objects.equals(typeSettings, newTypeSettings = this.getNewTypeSettings(typeSettings, oldRootPortletId, newRootPortletId, exactMatch))) continue;
                preparedStatement2.setString(1, newTypeSettings);
                preparedStatement2.setLong(2, resultSet.getLong("plid"));
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }

    protected void updatePortlet(String oldRootPortletId, String newRootPortletId) throws Exception {
        block2: {
            try {
                this.updatePortletId(oldRootPortletId, newRootPortletId);
                this.updatePortletItem(oldRootPortletId, newRootPortletId);
                this.updateResourceAction(oldRootPortletId, newRootPortletId);
                this.updateResourcePermission(oldRootPortletId, newRootPortletId, true);
                this.updateUserNotificationDelivery(oldRootPortletId, newRootPortletId);
                this.updateUserNotificationEvent(oldRootPortletId, newRootPortletId);
                this.updateInstanceablePortletPreferences(oldRootPortletId, newRootPortletId);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn(exception, exception);
            }
        }
    }

    protected void updatePortletId(String oldRootPortletId, String newRootPortletId) throws Exception {
        this.runSQL(StringBundler.concat((String[])new String[]{"update Portlet set portletId = '", newRootPortletId, "' where portletId = '", oldRootPortletId, "'"}));
    }

    protected void updatePortletItem(String oldRootPortletId, String newRootPortletId) throws Exception {
        this.runSQL(StringBundler.concat((String[])new String[]{"update PortletItem set portletId = '", newRootPortletId, "' where portletId = '", oldRootPortletId, "'"}));
    }

    protected void updateResourceAction(String oldName, String newName) throws Exception {
        ArrayList<String> actionIds = new ArrayList<String>();
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select actionId from ResourceAction where name = '" + newName + "'");
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                actionIds.add(resultSet.getString("actionId"));
            }
        }
        if (actionIds.isEmpty()) {
            this.runSQL(StringBundler.concat((String[])new String[]{"update ResourceAction set name = '", newName, "' where name = '", oldName, "'"}));
        } else {
            StringBundler sb = new StringBundler(5 + 3 * actionIds.size());
            sb.append("update ResourceAction set name = '");
            sb.append(newName);
            sb.append("' where name = '");
            sb.append(oldName);
            sb.append("' and actionId not in (");
            for (int i = 0; i < actionIds.size(); ++i) {
                sb.append("'");
                sb.append((String)actionIds.get(i));
                if (i == actionIds.size() - 1) {
                    sb.append("')");
                    continue;
                }
                sb.append("', ");
            }
            this.runSQL(sb.toString());
            this.runSQL("delete from ResourceAction where name = '" + oldName + "'");
        }
    }

    protected void updateResourcePermission(String oldRootPortletId, String newRootPortletId, boolean updateName) throws Exception {
        this.runSQL(StringBundler.concat((String[])new String[]{"update ResourcePermission set primKey = replace(primKey, ", "'_LAYOUT_", oldRootPortletId, "', '_LAYOUT_", newRootPortletId, "') where name = '", oldRootPortletId, "' and primKey like '%_LAYOUT_", oldRootPortletId, "'"}));
        if (!newRootPortletId.contains("_INSTANCE_")) {
            this.runSQL(StringBundler.concat((String[])new String[]{"update ResourcePermission set primKey = replace(", "primKey, '_LAYOUT_", oldRootPortletId, "_INSTANCE_', ", "'_LAYOUT_", newRootPortletId, "_INSTANCE_') where name = ", "'", oldRootPortletId, "' and primKey like '%_LAYOUT_", oldRootPortletId, "_INSTANCE_%'"}));
        }
        if (updateName) {
            this.runSQL(StringBundler.concat((String[])new String[]{"update ResourcePermission set primKey = '", newRootPortletId, "' where name = '", oldRootPortletId, "' and primKey = '", oldRootPortletId, "'"}));
            this.runSQL(StringBundler.concat((String[])new String[]{"update ResourcePermission set name = '", newRootPortletId, "' where name = '", oldRootPortletId, "'"}));
        }
    }

    protected void updateUserNotificationDelivery(String oldPortletId, String newPortletId) throws Exception {
        this.runSQL(StringBundler.concat((String[])new String[]{"update UserNotificationDelivery set portletId = '", newPortletId, "' where portletId = '", oldPortletId, "'"}));
    }

    protected void updateUserNotificationEvent(String oldPortletId, String newPortletId) throws Exception {
        this.runSQL(StringBundler.concat((String[])new String[]{"update UserNotificationEvent set type_ = '", newPortletId, "' where type_ = '", oldPortletId, "'"}));
    }

    protected void upgradeInstanceablePortletIds() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            String[][] renamePortletIdsArray;
            for (String[] renamePortletIds : renamePortletIdsArray = this.getRenamePortletIdsArray()) {
                String oldRootPortletId = renamePortletIds[0];
                String newRootPortletId = renamePortletIds[1];
                this.updateGroup(oldRootPortletId, newRootPortletId);
                this.updatePortlet(oldRootPortletId, newRootPortletId);
                this.updateLayoutRevisions(oldRootPortletId, newRootPortletId, false);
                this.updateLayouts(oldRootPortletId, newRootPortletId, false);
            }
        }
    }

    protected void upgradeUninstanceablePortletIds() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            String[] uninstanceablePortletIds;
            for (String portletId : uninstanceablePortletIds = this.getUninstanceablePortletIds()) {
                if (PortletIdCodec.hasInstanceId(portletId)) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn("Portlet " + portletId + " is already instanceable");
                    continue;
                }
                PortletIdCodec.validatePortletName(portletId);
                String newPortletInstanceKey = PortletIdCodec.encode(portletId);
                this.updateInstanceablePortletPreferences(portletId, newPortletInstanceKey);
                this.updateResourcePermission(portletId, newPortletInstanceKey, false);
                this.updateLayoutRevisions(portletId, newPortletInstanceKey, true);
                this.updateLayouts(portletId, newPortletInstanceKey, true);
            }
        }
    }

    private String _getStagedPortletId(String portletId) {
        String key = portletId;
        if (key.startsWith("staged-portlet_")) {
            return key;
        }
        return "staged-portlet_".concat(portletId);
    }
}

