/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.upgrade;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.BaseUpgradePortletId;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class BaseReplacePortletId
extends BaseUpgradePortletId {
    @Override
    protected void doUpgrade() throws Exception {
        HashMap<String, List> renamePortletIdsMap = new HashMap<String, List>();
        for (String[] renamePortletIds : this.getRenamePortletIdsArray()) {
            List sourcePortletIds = renamePortletIdsMap.computeIfAbsent(renamePortletIds[1], key -> new ArrayList());
            sourcePortletIds.add(renamePortletIds[0]);
        }
        ArrayList<String> clauses = new ArrayList<String>();
        for (Map.Entry entry : renamePortletIdsMap.entrySet()) {
            List sourcePortletIds = (List)entry.getValue();
            if (sourcePortletIds.size() <= 1) continue;
            for (int i = 0; i < sourcePortletIds.size() - 1; ++i) {
                String portletId1 = (String)sourcePortletIds.get(i);
                for (int j = i + 1; j < sourcePortletIds.size(); ++j) {
                    String portletId2 = (String)sourcePortletIds.get(j);
                    clauses.add(String.format("((PP1.portletId = '%s') AND (PP2.portletId = '%s'))", portletId1, portletId2));
                }
            }
        }
        if (!clauses.isEmpty()) {
            String orClauses = StringUtil.merge(clauses, " OR ");
            this._deleteConflictingPreferences(orClauses);
        }
        super.doUpgrade();
    }

    protected boolean hasPortlet(String portletId) throws SQLException {
        return this.hasRow("select count(*) from Portlet where portletId = ?", portletId);
    }

    protected boolean hasResourceAction(String name) throws SQLException {
        return this.hasRow("select count(*) from ResourceAction where name = ?", name);
    }

    protected boolean hasResourcePermission(String name) throws SQLException {
        return this.hasRow("select count(*) from ResourcePermission where name = ?", name);
    }

    /*
     * Exception decompiling
     */
    protected boolean hasRow(String sql, String value) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected void updatePortletId(String oldRootPortletId, String newRootPortletId) throws Exception {
        if (!this.hasPortlet(newRootPortletId)) {
            super.updatePortletId(oldRootPortletId, newRootPortletId);
        }
    }

    @Override
    protected void updateResourceAction(String oldName, String newName) throws Exception {
        if (this.hasResourceAction(newName)) {
            StringBundler sb = new StringBundler(3);
            sb.append("select RA1.resourceActionId from ResourceAction RA1 ");
            sb.append("inner join ResourceAction RA2 on RA1.actionId = ");
            sb.append("RA2.actionId where RA1.name = ? and RA2.name = ?");
            try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(sb.toString());
                 PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch(this.connection, "delete from ResourceAction where resourceActionId = ?");){
                preparedStatement1.setString(1, oldName);
                preparedStatement1.setString(2, newName);
                ResultSet resultSet = preparedStatement1.executeQuery();
                int deleteCount = 0;
                while (resultSet.next()) {
                    preparedStatement2.setLong(1, resultSet.getLong(1));
                    preparedStatement2.addBatch();
                    ++deleteCount;
                }
                if (deleteCount > 0) {
                    preparedStatement2.executeBatch();
                }
            }
        }
        super.updateResourceAction(oldName, newName);
    }

    @Override
    protected void updateResourcePermission(String oldRootPortletId, String newRootPortletId, boolean updateName) throws Exception {
        if (this.hasResourcePermission(newRootPortletId)) {
            try (PreparedStatement preparedStatement = this.connection.prepareStatement("delete from ResourcePermission where name = ?");){
                preparedStatement.setString(1, oldRootPortletId);
                preparedStatement.execute();
            }
        } else {
            super.updateResourcePermission(oldRootPortletId, newRootPortletId, updateName);
        }
    }

    private void _deleteConflictingPreferences(String orClauses) throws Exception {
        StringBundler sb = new StringBundler(4);
        sb.append("select PP1.portletPreferencesId from PortletPreferences ");
        sb.append("PP1 inner join PortletPreferences PP2 on PP1.plid = ");
        sb.append("PP2.plid where ");
        sb.append(orClauses);
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(sb.toString());
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch(this.connection, "delete from PortletPreferences where portletPreferencesId = ?");){
            ResultSet resultSet = preparedStatement1.executeQuery();
            int deleteCount = 0;
            while (resultSet.next()) {
                preparedStatement2.setLong(1, resultSet.getLong(1));
                preparedStatement2.addBatch();
                ++deleteCount;
            }
            if (deleteCount > 0) {
                preparedStatement2.executeBatch();
            }
        }
    }
}

