/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.upload;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ProgressTracker;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;

public class ProgressInputStream
extends InputStream {
    private static final int _DEFAULT_INITIAL_BUFFER_SIZE = 4096;
    private static final Log _log = LogFactoryUtil.getLog(ProgressInputStream.class);
    private final InputStream _inputStream;
    private final PortletSession _portletSession;
    private final String _progressId;
    private long _totalRead;
    private final long _totalSize;

    public ProgressInputStream(PortletRequest portletRequest, InputStream inputStream, long totalSize, String progressId) {
        this._inputStream = inputStream;
        this._totalSize = totalSize;
        this._progressId = progressId;
        this._portletSession = portletRequest.getPortletSession();
        this.initProgress();
    }

    @Override
    public int available() throws IOException {
        return this._inputStream.available();
    }

    public void clearProgress() {
        this._portletSession.removeAttribute(this._getPercentAttributeName());
    }

    @Override
    public void close() throws IOException {
        this._inputStream.close();
    }

    public long getTotalRead() {
        return this._totalRead;
    }

    public void initProgress() {
        ProgressTracker progressTracker = new ProgressTracker(this._progressId);
        progressTracker.initialize(this._portletSession);
    }

    @Override
    public void mark(int readlimit) {
        this._inputStream.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this._inputStream.markSupported();
    }

    @Override
    public int read() throws IOException {
        return this._inputStream.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead = super.read(b, off, len);
        this._updateProgress(bytesRead);
        return bytesRead;
    }

    public void readAll(OutputStream outputStream) throws IOException {
        byte[] buffer = new byte[4096];
        int len = 0;
        while ((len = this.read(buffer)) > 0) {
            outputStream.write(buffer, 0, len);
        }
        outputStream.close();
    }

    @Override
    public void reset() throws IOException {
        this._inputStream.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        long result = this._inputStream.skip(n);
        this._updateProgress(result);
        return result;
    }

    private String _getPercentAttributeName() {
        return ProgressTracker.PERCENT + this._progressId;
    }

    private void _updateProgress(long bytesRead) {
        if (bytesRead > 0L) {
            this._totalRead += bytesRead;
        } else if (this._totalSize > 0L) {
            this._totalRead = this._totalSize;
        }
        int percent = 0;
        if (this._totalSize > 0L) {
            percent = (int)(this._totalRead * 100L / this._totalSize);
        }
        if (_log.isDebugEnabled()) {
            _log.debug(StringBundler.concat((Object[])new Object[]{this._totalRead, "/", this._totalSize, "=", percent}));
        }
        ProgressTracker progressTracker = (ProgressTracker)this._portletSession.getAttribute(this._getPercentAttributeName(), 1);
        Integer curPercent = null;
        if (progressTracker != null) {
            curPercent = progressTracker.getPercent();
        }
        if (curPercent == null || percent - curPercent >= 1) {
            if (progressTracker == null) {
                progressTracker = new ProgressTracker(this._progressId);
                progressTracker.initialize(this._portletSession);
            }
            progressTracker.setPercent(percent);
        }
    }
}

