/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class SessionTreeJSClicks {
    private static final Log _log = LogFactoryUtil.getLog(SessionTreeJSClicks.class);

    public static void closeLayoutNodes(HttpServletRequest httpServletRequest, String treeId, boolean privateLayout, long layoutId, boolean recursive) {
        try {
            ArrayList<String> layoutIds = new ArrayList<String>();
            layoutIds.add(String.valueOf(layoutId));
            if (recursive) {
                SessionTreeJSClicks.getLayoutIds(httpServletRequest, privateLayout, layoutId, layoutIds);
            }
            SessionTreeJSClicks.closeNodes(httpServletRequest, treeId, layoutIds.toArray(new String[0]));
        }
        catch (Exception exception) {
            _log.error(exception, exception);
        }
    }

    public static void closeNode(HttpServletRequest httpServletRequest, String treeId, String nodeId) {
        while (true) {
            try {
                PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences(httpServletRequest);
                String openNodesString = portalPreferences.getValue(SessionTreeJSClicks.class.getName(), treeId);
                openNodesString = StringUtil.removeFromList(openNodesString, nodeId);
                portalPreferences.setValue(SessionTreeJSClicks.class.getName(), treeId, openNodesString);
                return;
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug(concurrentModificationException, concurrentModificationException);
                continue;
            }
            catch (Exception exception) {
                _log.error(exception, exception);
                return;
            }
            break;
        }
    }

    public static void closeNodes(HttpServletRequest httpServletRequest, String treeId) {
        while (true) {
            try {
                PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences(httpServletRequest);
                portalPreferences.setValue(SessionTreeJSClicks.class.getName(), treeId, "");
                return;
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug(concurrentModificationException, concurrentModificationException);
                continue;
            }
            catch (Exception exception) {
                _log.error(exception, exception);
                return;
            }
            break;
        }
    }

    public static void closeNodes(HttpServletRequest httpServletRequest, String treeId, String[] nodeIds) {
        while (true) {
            try {
                PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences(httpServletRequest);
                String openNodesString = portalPreferences.getValue(SessionTreeJSClicks.class.getName(), treeId);
                for (String nodeId : nodeIds) {
                    openNodesString = StringUtil.removeFromList(openNodesString, nodeId);
                }
                portalPreferences.setValue(SessionTreeJSClicks.class.getName(), treeId, openNodesString);
                return;
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug(concurrentModificationException, concurrentModificationException);
                continue;
            }
            catch (Exception exception) {
                _log.error(exception, exception);
                return;
            }
            break;
        }
    }

    public static String getOpenNodes(HttpServletRequest httpServletRequest, String treeId) {
        try {
            PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences(httpServletRequest);
            return portalPreferences.getValue(SessionTreeJSClicks.class.getName(), treeId);
        }
        catch (Exception exception) {
            _log.error(exception, exception);
            return null;
        }
    }

    public static void openLayoutNodes(HttpServletRequest httpServletRequest, String treeId, boolean privateLayout, long layoutId, boolean recursive) {
        try {
            ArrayList<String> layoutIds = new ArrayList<String>();
            layoutIds.add(String.valueOf(layoutId));
            if (recursive) {
                SessionTreeJSClicks.getLayoutIds(httpServletRequest, privateLayout, layoutId, layoutIds);
            }
            SessionTreeJSClicks.openNodes(httpServletRequest, treeId, layoutIds.toArray(new String[0]));
        }
        catch (Exception exception) {
            _log.error(exception, exception);
        }
    }

    public static void openNode(HttpServletRequest httpServletRequest, String treeId, String nodeId) {
        while (true) {
            try {
                PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences(httpServletRequest);
                String openNodesString = portalPreferences.getValue(SessionTreeJSClicks.class.getName(), treeId);
                openNodesString = StringUtil.add(openNodesString, nodeId);
                portalPreferences.setValue(SessionTreeJSClicks.class.getName(), treeId, openNodesString);
                return;
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug(concurrentModificationException, concurrentModificationException);
                continue;
            }
            catch (Exception exception) {
                _log.error(exception, exception);
                return;
            }
            break;
        }
    }

    public static void openNodes(HttpServletRequest httpServletRequest, String treeId, String[] nodeIds) {
        while (true) {
            try {
                PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences(httpServletRequest);
                String openNodesString = portalPreferences.getValue(SessionTreeJSClicks.class.getName(), treeId);
                for (String nodeId : nodeIds) {
                    openNodesString = StringUtil.add(openNodesString, nodeId);
                }
                portalPreferences.setValue(SessionTreeJSClicks.class.getName(), treeId, openNodesString);
                return;
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug(concurrentModificationException, concurrentModificationException);
                continue;
            }
            catch (Exception exception) {
                _log.error(exception, exception);
                return;
            }
            break;
        }
    }

    protected static List<String> getLayoutIds(HttpServletRequest httpServletRequest, boolean privateLayout, long parentLayoutId, List<String> layoutIds) throws Exception {
        long groupId = ParamUtil.getLong(httpServletRequest, "groupId");
        List<Layout> layouts = LayoutLocalServiceUtil.getLayouts(groupId, privateLayout, parentLayoutId);
        for (Layout layout : layouts) {
            layoutIds.add(String.valueOf(layout.getLayoutId()));
            SessionTreeJSClicks.getLayoutIds(httpServletRequest, privateLayout, layout.getLayoutId(), layoutIds);
        }
        return layoutIds;
    }
}

