/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.workflow;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.WorkflowDefinitionLink;
import com.liferay.portal.kernel.model.WorkflowInstanceLink;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.WorkflowInstanceLinkLocalServiceUtil;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.workflow.WorkflowEngineManagerUtil;
import com.liferay.portal.kernel.workflow.WorkflowException;
import com.liferay.portal.kernel.workflow.WorkflowHandler;
import com.liferay.portal.kernel.workflow.WorkflowInstance;
import com.liferay.portal.kernel.workflow.WorkflowInstanceManagerUtil;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceRegistration;
import com.liferay.registry.collections.ServiceReferenceMapper;
import com.liferay.registry.collections.ServiceRegistrationMap;
import com.liferay.registry.collections.ServiceRegistrationMapImpl;
import com.liferay.registry.collections.ServiceTrackerCollections;
import com.liferay.registry.collections.ServiceTrackerMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Predicate;

public class WorkflowHandlerRegistryUtil {
    private static final Log _log = LogFactoryUtil.getLog(WorkflowHandlerRegistryUtil.class);
    private static final ServiceTrackerMap<String, WorkflowHandler<?>> _scopeableWorkflowHandlerServiceTrackerMap;
    private static final ServiceRegistrationMap<WorkflowHandler<?>> _serviceRegistrationMap;
    private static final ServiceTrackerMap<String, WorkflowHandler<?>> _workflowHandlerServiceTrackerMap;

    public static List<WorkflowHandler<?>> getScopeableWorkflowHandlers() {
        return WorkflowHandlerRegistryUtil._getWorkflowHandlers(_scopeableWorkflowHandlerServiceTrackerMap);
    }

    public static <T> WorkflowHandler<T> getWorkflowHandler(String className) {
        return (WorkflowHandler)_workflowHandlerServiceTrackerMap.getService((Object)className);
    }

    public static List<WorkflowHandler<?>> getWorkflowHandlers() {
        return WorkflowHandlerRegistryUtil._getWorkflowHandlers(_workflowHandlerServiceTrackerMap);
    }

    @Deprecated
    public static void register(List<WorkflowHandler<?>> workflowHandlers) {
        for (WorkflowHandler<?> workflowHandler : workflowHandlers) {
            WorkflowHandlerRegistryUtil.register(workflowHandler);
        }
    }

    @Deprecated
    public static void register(WorkflowHandler<?> workflowHandler) {
        Registry registry = RegistryUtil.getRegistry();
        ServiceRegistration serviceRegistration = registry.registerService(WorkflowHandler.class, workflowHandler);
        _serviceRegistrationMap.put(workflowHandler, (Object)serviceRegistration);
    }

    public static <T> void startWorkflowInstance(long companyId, long groupId, long userId, String className, long classPK, T model, ServiceContext serviceContext) throws PortalException {
        Map<String, Serializable> workflowContext = (Map<String, Serializable>)((Object)serviceContext.removeAttribute("workflowContext"));
        if (workflowContext == null) {
            workflowContext = Collections.emptyMap();
        }
        WorkflowHandlerRegistryUtil.startWorkflowInstance(companyId, groupId, userId, className, classPK, model, serviceContext, workflowContext);
    }

    public static <T> T startWorkflowInstance(final long companyId, final long groupId, final long userId, final String className, final long classPK, final T model, ServiceContext serviceContext, Map<String, Serializable> workflowContext) throws PortalException {
        if (serviceContext.getWorkflowAction() != 1) {
            return model;
        }
        final WorkflowHandler<T> workflowHandler = WorkflowHandlerRegistryUtil.getWorkflowHandler(className);
        if (workflowHandler == null) {
            if (WorkflowThreadLocal.isEnabled()) {
                throw new WorkflowException("No workflow handler found for " + className);
            }
            return model;
        }
        boolean hasWorkflowInstanceInProgress = WorkflowHandlerRegistryUtil._hasWorkflowInstanceInProgress(companyId, groupId, className, classPK);
        if (hasWorkflowInstanceInProgress) {
            if (_log.isWarnEnabled()) {
                _log.warn(StringBundler.concat((Object[])new Object[]{"Workflow already started for class ", className, " with primary key ", classPK, " in group ", groupId}));
            }
            return model;
        }
        WorkflowDefinitionLink workflowDefinitionLink = null;
        if (WorkflowThreadLocal.isEnabled() && WorkflowEngineManagerUtil.isDeployed()) {
            workflowDefinitionLink = workflowHandler.getWorkflowDefinitionLink(companyId, groupId, classPK);
        }
        int status = 1;
        if (workflowDefinitionLink == null) {
            status = 0;
        }
        workflowContext = new HashMap<String, Serializable>(workflowContext);
        workflowContext.put("companyId", (Serializable)((Object)String.valueOf(companyId)));
        workflowContext.put("entryClassName", (Serializable)((Object)className));
        workflowContext.put("entryClassPK", (Serializable)((Object)String.valueOf(classPK)));
        workflowContext.put("entryType", (Serializable)((Object)workflowHandler.getType(LocaleUtil.getDefault())));
        workflowContext.put("groupId", (Serializable)((Object)String.valueOf(groupId)));
        workflowContext.put("serviceContext", serviceContext);
        workflowContext.put("taskComments", (Serializable)((Object)GetterUtil.getString(serviceContext.getAttribute("comments"))));
        workflowContext.put("userId", (Serializable)((Object)String.valueOf(userId)));
        T updatedModel = workflowHandler.updateStatus(status, workflowContext);
        if (workflowDefinitionLink != null) {
            final Map<String, Serializable> tempWorkflowContext = workflowContext;
            TransactionCommitCallbackUtil.registerCallback(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    boolean hasWorkflowInstanceInProgress = WorkflowHandlerRegistryUtil._hasWorkflowInstanceInProgress(companyId, groupId, className, classPK);
                    if (!hasWorkflowInstanceInProgress) {
                        workflowHandler.startWorkflowInstance(companyId, groupId, userId, classPK, model, tempWorkflowContext);
                    }
                    return null;
                }
            });
        }
        return updatedModel;
    }

    public static <T> void startWorkflowInstance(long companyId, long userId, String className, long classPK, T model, ServiceContext serviceContext) throws PortalException {
        Map<String, Serializable> workflowContext = (Map<String, Serializable>)((Object)serviceContext.removeAttribute("workflowContext"));
        if (workflowContext == null) {
            workflowContext = Collections.emptyMap();
        }
        WorkflowHandlerRegistryUtil.startWorkflowInstance(companyId, 0L, userId, className, classPK, model, serviceContext, workflowContext);
    }

    public static <T> void startWorkflowInstance(long companyId, long userId, String className, long classPK, T model, ServiceContext serviceContext, Map<String, Serializable> workflowContext) throws PortalException {
        WorkflowHandlerRegistryUtil.startWorkflowInstance(companyId, 0L, userId, className, classPK, model, serviceContext, workflowContext);
    }

    @Deprecated
    public static void unregister(List<WorkflowHandler<?>> workflowHandlers) {
        for (WorkflowHandler<?> workflowHandler : workflowHandlers) {
            WorkflowHandlerRegistryUtil.unregister(workflowHandler);
        }
    }

    @Deprecated
    public static void unregister(WorkflowHandler<?> workflowHandler) {
        ServiceRegistration serviceRegistration = (ServiceRegistration)_serviceRegistrationMap.remove(workflowHandler);
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
        }
    }

    public static <T> T updateStatus(int status, Map<String, Serializable> workflowContext) throws PortalException {
        String className = (String)((Object)workflowContext.get("entryClassName"));
        WorkflowHandler<T> workflowHandler = WorkflowHandlerRegistryUtil.getWorkflowHandler(className);
        if (workflowHandler != null) {
            return workflowHandler.updateStatus(status, workflowContext);
        }
        return null;
    }

    private static List<WorkflowHandler<?>> _getWorkflowHandlers(ServiceTrackerMap<String, WorkflowHandler<?>> workflowHandlerServiceTrackerMap) {
        ArrayList workflowHandlers = new ArrayList();
        for (String modelClassName : workflowHandlerServiceTrackerMap.keySet()) {
            workflowHandlers.add((WorkflowHandler<?>)workflowHandlerServiceTrackerMap.getService((Object)modelClassName));
        }
        return workflowHandlers;
    }

    private static boolean _hasWorkflowInstanceInProgress(long companyId, long groupId, String className, long classPK) throws PortalException {
        WorkflowInstanceLink workflowInstanceLink = WorkflowInstanceLinkLocalServiceUtil.fetchWorkflowInstanceLink(companyId, groupId, className, classPK);
        if (workflowInstanceLink == null) {
            return false;
        }
        WorkflowInstance workflowInstance = WorkflowInstanceManagerUtil.getWorkflowInstance(companyId, workflowInstanceLink.getWorkflowInstanceId());
        return !workflowInstance.isComplete();
    }

    static {
        _serviceRegistrationMap = new ServiceRegistrationMapImpl();
        _workflowHandlerServiceTrackerMap = ServiceTrackerCollections.openSingleValueMap(WorkflowHandler.class, null, (ServiceReferenceMapper)new WorkflowHandlerServiceReferenceMapper(handler -> true));
        _scopeableWorkflowHandlerServiceTrackerMap = ServiceTrackerCollections.openSingleValueMap(WorkflowHandler.class, null, (ServiceReferenceMapper)new WorkflowHandlerServiceReferenceMapper(handler -> handler.isScopeable()));
    }

    private static class WorkflowHandlerServiceReferenceMapper
    implements ServiceReferenceMapper<String, WorkflowHandler<?>> {
        private final Predicate<WorkflowHandler<?>> _predicate;

        public void map(ServiceReference<WorkflowHandler<?>> serviceReference, ServiceReferenceMapper.Emitter<String> emitter) {
            Registry registry = RegistryUtil.getRegistry();
            WorkflowHandler workflowHandler = (WorkflowHandler)registry.getService(serviceReference);
            if (this._predicate.test(workflowHandler)) {
                emitter.emit((Object)workflowHandler.getClassName());
            }
        }

        private WorkflowHandlerServiceReferenceMapper(Predicate<WorkflowHandler<?>> predicate) {
            this._predicate = predicate;
        }
    }
}

