/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.kernel.processor;

import com.liferay.document.library.kernel.processor.AudioProcessor;
import com.liferay.document.library.kernel.processor.DLProcessorHelperUtil;
import com.liferay.portal.kernel.repository.model.FileVersion;
import java.io.InputStream;
import java.util.Set;

public class AudioProcessorUtil {
    public static void generateAudio(FileVersion sourceFileVersion, FileVersion destinationFileVersion) throws Exception {
        AudioProcessor audioProcessor = AudioProcessorUtil.getAudioProcessor();
        if (audioProcessor != null) {
            audioProcessor.generateAudio(sourceFileVersion, destinationFileVersion);
        }
    }

    public static Set<String> getAudioMimeTypes() {
        AudioProcessor audioProcessor = AudioProcessorUtil.getAudioProcessor();
        if (audioProcessor == null) {
            return null;
        }
        return audioProcessor.getAudioMimeTypes();
    }

    public static AudioProcessor getAudioProcessor() {
        return (AudioProcessor)((Object)DLProcessorHelperUtil.getDLProcessor("AudioProcessor"));
    }

    public static InputStream getPreviewAsStream(FileVersion fileVersion, String type) throws Exception {
        AudioProcessor audioProcessor = AudioProcessorUtil.getAudioProcessor();
        if (audioProcessor == null) {
            return null;
        }
        return audioProcessor.getPreviewAsStream(fileVersion, type);
    }

    public static long getPreviewFileSize(FileVersion fileVersion, String type) throws Exception {
        AudioProcessor audioProcessor = AudioProcessorUtil.getAudioProcessor();
        if (audioProcessor == null) {
            return 0L;
        }
        return audioProcessor.getPreviewFileSize(fileVersion, type);
    }

    public static boolean hasAudio(FileVersion fileVersion) {
        AudioProcessor audioProcessor = AudioProcessorUtil.getAudioProcessor();
        if (audioProcessor == null) {
            return false;
        }
        return audioProcessor.hasAudio(fileVersion);
    }

    public static boolean isAudioSupported(FileVersion fileVersion) {
        AudioProcessor audioProcessor = AudioProcessorUtil.getAudioProcessor();
        if (audioProcessor == null) {
            return false;
        }
        return audioProcessor.isAudioSupported(fileVersion);
    }

    public static boolean isAudioSupported(String mimeType) {
        AudioProcessor audioProcessor = AudioProcessorUtil.getAudioProcessor();
        if (audioProcessor == null) {
            return false;
        }
        return audioProcessor.isAudioSupported(mimeType);
    }

    public static boolean isEnabled() {
        AudioProcessor audioProcessor = AudioProcessorUtil.getAudioProcessor();
        if (audioProcessor == null) {
            return false;
        }
        return audioProcessor.isEnabled();
    }

    public static boolean isSupported(String mimeType) {
        AudioProcessor audioProcessor = AudioProcessorUtil.getAudioProcessor();
        if (audioProcessor == null) {
            return false;
        }
        return audioProcessor.isSupported(mimeType);
    }

    public static void trigger(FileVersion sourceFileVersion, FileVersion destinationFileVersion) {
        AudioProcessor audioProcessor = AudioProcessorUtil.getAudioProcessor();
        if (audioProcessor == null) {
            return;
        }
        audioProcessor.trigger(sourceFileVersion, destinationFileVersion);
    }
}

