/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.kernel.store;

import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.Objects;

public final class DLStoreRequest
implements Serializable {
    private static final long serialVersionUID = -3103134314128654067L;
    private final String _className;
    private final long _classPK;
    private final long _companyId;
    private final String _entryURL;
    private final String _fileExtension;
    private final String _fileName;
    private final long _newRepositoryId;
    private final long _repositoryId;
    private final long _size;
    private final String _sourceFileName;
    private final boolean _validateFileExtension;
    private final String _versionLabel;

    public static Builder builder(long companyId, long repositoryId, String fileName) {
        if (companyId < 0L) {
            throw new IllegalArgumentException("Company ID is less than 0");
        }
        if (repositoryId < 0L) {
            throw new IllegalArgumentException("Repository ID is less than 0");
        }
        Objects.requireNonNull(fileName);
        return new Builder(companyId, repositoryId, fileName);
    }

    public String getClassName() {
        return this._className;
    }

    public long getClassPK() {
        return this._classPK;
    }

    public long getCompanyId() {
        return this._companyId;
    }

    public String getEntryURL() {
        return this._entryURL;
    }

    public String getFileExtension() {
        return this._fileExtension;
    }

    public String getFileName() {
        return this._fileName;
    }

    public long getNewRepositoryId() {
        return this._newRepositoryId;
    }

    public long getRepositoryId() {
        return this._repositoryId;
    }

    public long getSize() {
        return this._size;
    }

    public String getSourceFileName() {
        return this._sourceFileName;
    }

    public String getVersionLabel() {
        return this._versionLabel;
    }

    public boolean isValidateFileExtension() {
        return this._validateFileExtension;
    }

    private DLStoreRequest(String className, long classPK, long companyId, String entryURL, String fileExtension, String fileName, long newRepositoryId, long repositoryId, long size, String sourceFileName, boolean validateFileExtension, String versionLabel) {
        this._className = className;
        this._classPK = classPK;
        this._companyId = companyId;
        this._entryURL = entryURL;
        this._fileExtension = fileExtension;
        this._fileName = fileName;
        this._newRepositoryId = newRepositoryId;
        this._repositoryId = repositoryId;
        this._size = size;
        this._sourceFileName = sourceFileName;
        this._validateFileExtension = validateFileExtension;
        this._versionLabel = versionLabel;
    }

    public static class Builder {
        private String _className = "";
        private long _classPK = -1L;
        private long _companyId;
        private String _entryURL = "";
        private String _fileExtension;
        private String _fileName;
        private long _newRepositoryId = -1L;
        private long _repositoryId;
        private long _size = -1L;
        private String _sourceFileName;
        private boolean _validateFileExtension;
        private String _versionLabel;

        public DLStoreRequest build() {
            if (this._classPK > 0L && Validator.isNull(this._className)) {
                throw new IllegalArgumentException("Class name is null and class PK is greater than 0");
            }
            if (this._fileExtension == null) {
                this._fileExtension = "";
            }
            if (this._sourceFileName == null) {
                this._sourceFileName = this._fileName;
            }
            if (this._versionLabel == null) {
                this._versionLabel = "1.0";
            }
            return new DLStoreRequest(this._className, this._classPK, this._companyId, this._entryURL, this._fileExtension, this._fileName, this._newRepositoryId, this._repositoryId, this._size, this._sourceFileName, this._validateFileExtension, this._versionLabel);
        }

        public Builder className(Object object) {
            Objects.requireNonNull(object, "Object is null");
            this._className = ClassUtil.getClassName(object);
            return this;
        }

        public Builder className(String className) {
            Objects.requireNonNull(className, "Class name is null");
            this._className = className;
            return this;
        }

        public Builder classPK(long classPK) {
            if (classPK < 0L) {
                throw new IllegalArgumentException("Class PK is less than 0");
            }
            this._classPK = classPK;
            return this;
        }

        public Builder entryURL(String entryURL) {
            this._entryURL = entryURL;
            return this;
        }

        public Builder fileExtension(String fileExtension) {
            this._fileExtension = fileExtension;
            return this;
        }

        public Builder newRepositoryId(long newRepositoryId) {
            this._newRepositoryId = newRepositoryId;
            return this;
        }

        public Builder size(long size) {
            this._size = size;
            return this;
        }

        public Builder sourceFileName(String sourceFileName) {
            this._sourceFileName = sourceFileName;
            return this;
        }

        public Builder validateFileExtension(boolean validateFileExtension) {
            this._validateFileExtension = validateFileExtension;
            return this;
        }

        public Builder versionLabel(String versionLabel) {
            this._versionLabel = versionLabel;
            return this;
        }

        private Builder(long companyId, long repositoryId, String fileName) {
            this._companyId = companyId;
            this._repositoryId = repositoryId;
            this._fileName = fileName;
        }
    }
}

