/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.expando.kernel.util;

import com.liferay.expando.kernel.exception.ValueDataException;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;

public class ExpandoUtil {
    public static Map<String, Serializable> getExpandoBridgeAttributes(ExpandoBridge expandoBridge, HttpServletRequest httpServletRequest) throws PortalException {
        HashMap<String, Serializable> attributes = new HashMap<String, Serializable>();
        ArrayList<String> names = new ArrayList<String>();
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String param = (String)enumeration.nextElement();
            if (!param.contains("ExpandoAttributeName--")) continue;
            String name = ParamUtil.getString(httpServletRequest, param);
            names.add(name);
        }
        for (String name : names) {
            int type = expandoBridge.getAttributeType(name);
            UnicodeProperties unicodeProperties = expandoBridge.getAttributeProperties(name);
            String displayType = GetterUtil.getString(unicodeProperties.getProperty("display-type"), "text-box");
            Serializable value = ExpandoUtil._getExpandoValue(httpServletRequest, "ExpandoAttribute--" + name + "--", type, displayType);
            attributes.put(name, value);
        }
        return attributes;
    }

    public static Map<String, Serializable> getExpandoBridgeAttributes(ExpandoBridge expandoBridge, PortletRequest portletRequest) throws PortalException {
        return ExpandoUtil.getExpandoBridgeAttributes(expandoBridge, PortalUtil.getHttpServletRequest(portletRequest));
    }

    private static Serializable _getExpandoValue(HttpServletRequest httpServletRequest, String name, int type, String displayType) throws PortalException {
        Object value = null;
        if (type == 1) {
            value = ParamUtil.getBoolean(httpServletRequest, name);
        } else if (type != 2) {
            if (type == 3) {
                int valueDateMonth = ParamUtil.getInteger(httpServletRequest, name + "Month");
                int valueDateDay = ParamUtil.getInteger(httpServletRequest, name + "Day");
                int valueDateYear = ParamUtil.getInteger(httpServletRequest, name + "Year");
                int valueDateHour = ParamUtil.getInteger(httpServletRequest, name + "Hour");
                int valueDateMinute = ParamUtil.getInteger(httpServletRequest, name + "Minute");
                int valueDateAmPm = ParamUtil.getInteger(httpServletRequest, name + "AmPm");
                if (valueDateAmPm == 1) {
                    valueDateHour += 12;
                }
                TimeZone timeZone = null;
                User user = PortalUtil.getUser(httpServletRequest);
                if (user != null) {
                    timeZone = user.getTimeZone();
                }
                value = PortalUtil.getDate(valueDateMonth, valueDateDay, valueDateYear, valueDateHour, valueDateMinute, timeZone, ValueDataException.class);
            } else if (type != 4) {
                if (type == 5) {
                    value = ParamUtil.getDouble(httpServletRequest, name);
                } else if (type == 6) {
                    Object[] values = httpServletRequest.getParameterValues(name);
                    if (displayType.equals("text-box") && ArrayUtil.isNotEmpty(values)) {
                        values = StringUtil.splitLines((String)values[0]);
                    }
                    value = GetterUtil.getDoubleValues((String[])values);
                } else if (type == 7) {
                    value = Float.valueOf(ParamUtil.getFloat(httpServletRequest, name));
                } else if (type == 8) {
                    Object[] values = httpServletRequest.getParameterValues(name);
                    if (displayType.equals("text-box") && ArrayUtil.isNotEmpty(values)) {
                        values = StringUtil.splitLines((String)values[0]);
                    }
                    value = GetterUtil.getFloatValues((String[])values);
                } else if (type == 9) {
                    value = ParamUtil.getInteger(httpServletRequest, name);
                } else if (type == 10) {
                    Object[] values = httpServletRequest.getParameterValues(name);
                    if (displayType.equals("text-box") && ArrayUtil.isNotEmpty(values)) {
                        values = StringUtil.splitLines((String)values[0]);
                    }
                    value = GetterUtil.getIntegerValues((String[])values);
                } else if (type == 11) {
                    value = ParamUtil.getLong(httpServletRequest, name);
                } else if (type == 12) {
                    Object[] values = httpServletRequest.getParameterValues(name);
                    if (displayType.equals("text-box") && ArrayUtil.isNotEmpty(values)) {
                        values = StringUtil.splitLines((String)values[0]);
                    }
                    value = GetterUtil.getLongValues((String[])values);
                } else if (type == 17) {
                    value = ParamUtil.getNumber(httpServletRequest, name);
                } else if (type == 18) {
                    Object[] values = httpServletRequest.getParameterValues(name);
                    if (displayType.equals("text-box") && ArrayUtil.isNotEmpty(values)) {
                        values = StringUtil.splitLines((String)values[0]);
                    }
                    value = GetterUtil.getNumberValues((String[])values);
                } else if (type == 13) {
                    value = ParamUtil.getShort(httpServletRequest, name);
                } else if (type == 14) {
                    Object[] values = httpServletRequest.getParameterValues(name);
                    if (displayType.equals("text-box") && ArrayUtil.isNotEmpty(values)) {
                        values = StringUtil.splitLines((String)values[0]);
                    }
                    value = GetterUtil.getShortValues((String[])values);
                } else if (type == 16) {
                    Object[] values = httpServletRequest.getParameterValues(name);
                    if (displayType.equals("text-box") && ArrayUtil.isNotEmpty(values)) {
                        values = StringUtil.splitLines((String)values[0]);
                    }
                    value = values;
                } else {
                    value = type == 20 ? (Serializable)((Object)LocalizationUtil.getLocalizationMap(httpServletRequest, name)) : ParamUtil.getString(httpServletRequest, name);
                }
            }
        }
        return value;
    }
}

