/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.bean;

import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.lang.ThreadContextClassLoaderUtil;
import com.liferay.portal.kernel.bean.BeanLocator;
import com.liferay.portal.kernel.bean.BeanLocatorException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.Map;

public class PortalBeanLocatorUtil {
    private static final Log _log = LogFactoryUtil.getLog(PortalBeanLocatorUtil.class);
    private static BeanLocator _beanLocator;

    public static BeanLocator getBeanLocator() {
        return _beanLocator;
    }

    public static <T> Map<String, T> locate(Class<T> clazz) {
        BeanLocator beanLocator = _beanLocator;
        if (beanLocator == null) {
            _log.error("BeanLocator is null");
            throw new BeanLocatorException("BeanLocator is not set");
        }
        try (SafeCloseable safeCloseable = ThreadContextClassLoaderUtil.swap((ClassLoader)beanLocator.getClassLoader());){
            Map<String, T> map = beanLocator.locate(clazz);
            return map;
        }
    }

    public static Object locate(String name) {
        BeanLocator beanLocator = _beanLocator;
        if (beanLocator == null) {
            _log.error("BeanLocator is null");
            throw new BeanLocatorException("BeanLocator is not set");
        }
        try (SafeCloseable safeCloseable = ThreadContextClassLoaderUtil.swap((ClassLoader)beanLocator.getClassLoader());){
            Object object = beanLocator.locate(name);
            return object;
        }
    }

    public static void reset() {
        PortalBeanLocatorUtil.setBeanLocator(null);
    }

    public static void setBeanLocator(BeanLocator beanLocator) {
        if (_log.isDebugEnabled()) {
            if (beanLocator == null) {
                _log.debug("Setting BeanLocator " + beanLocator);
            } else {
                _log.debug("Setting BeanLocator " + beanLocator.hashCode());
            }
        }
        _beanLocator = beanLocator;
    }
}

