/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cluster;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.security.SecureRandomUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

public class ClusterRequest
implements Serializable {
    private boolean _fireAndForget;
    private final boolean _multicast;
    private final Serializable _payload;
    private final boolean _skipLocal;
    private final Set<String> _targetClusterNodeIds = new HashSet<String>();
    private final String _uuid;

    public static ClusterRequest createMulticastRequest(Serializable payload) {
        return ClusterRequest.createMulticastRequest(payload, false);
    }

    public static ClusterRequest createMulticastRequest(Serializable payload, boolean skipLocal) {
        return new ClusterRequest(payload, skipLocal, true, new String[0]);
    }

    public static ClusterRequest createUnicastRequest(Serializable payload, String ... targetClusterNodeIds) {
        if (ArrayUtil.isEmpty(targetClusterNodeIds)) {
            throw new NullPointerException("Target cluster node IDs is null");
        }
        return new ClusterRequest(payload, false, false, targetClusterNodeIds);
    }

    public Serializable getPayload() {
        return this._payload;
    }

    public Set<String> getTargetClusterNodeIds() {
        return Collections.unmodifiableSet(this._targetClusterNodeIds);
    }

    public String getUuid() {
        return this._uuid;
    }

    public boolean isFireAndForget() {
        return this._fireAndForget;
    }

    public boolean isMulticast() {
        return this._multicast;
    }

    public boolean isSkipLocal() {
        return this._skipLocal;
    }

    public void setFireAndForget(boolean fireAndForget) {
        this._fireAndForget = fireAndForget;
    }

    public String toString() {
        StringBundler sb = new StringBundler(11);
        sb.append("{multicast=");
        sb.append(this._multicast);
        sb.append(", payload=");
        sb.append((Object)this._payload);
        sb.append(", skipLocal=");
        sb.append(this._skipLocal);
        if (!this._multicast) {
            sb.append(", _targetClusterNodeIds=");
            sb.append(this._targetClusterNodeIds);
        }
        sb.append(", uuid=");
        sb.append(this._uuid);
        sb.append("}");
        return sb.toString();
    }

    private ClusterRequest(Serializable payload, boolean skipLocal, boolean multicast, String ... targetClusterNodeIds) {
        if (payload == null) {
            throw new NullPointerException("Payload is null");
        }
        this._payload = payload;
        this._skipLocal = skipLocal;
        this._multicast = multicast;
        this._uuid = this._generateUUID();
        for (String targetClusterNodeId : targetClusterNodeIds) {
            this._targetClusterNodeIds.add(targetClusterNodeId);
        }
    }

    private String _generateUUID() {
        UUID uuid = new UUID(SecureRandomUtil.nextLong(), SecureRandomUtil.nextLong());
        return uuid.toString();
    }
}

