/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.concurrent;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class TaskQueue<E> {
    private final int _capacity;
    private final AtomicInteger _count = new AtomicInteger();
    private Node<E> _headNode;
    private final Condition _notEmptyCondition;
    private final ReentrantLock _putLock = new ReentrantLock();
    private Node<E> _tailNode;
    private final ReentrantLock _takeLock = new ReentrantLock(true);

    public TaskQueue() {
        this(Integer.MAX_VALUE);
    }

    public TaskQueue(int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        this._capacity = capacity;
        this._headNode = new Node<Object>(null);
        this._tailNode = this._headNode;
        this._notEmptyCondition = this._takeLock.newCondition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int drainTo(Collection<E> collection) {
        if (collection == null) {
            throw new NullPointerException();
        }
        this._takeLock.lock();
        try {
            int n;
            block9: {
                int count;
                Node<E> headNode = this._headNode;
                int size = this._count.get();
                try {
                    for (count = 0; count < size; ++count) {
                        Node currentNode = headNode._nextNode;
                        collection.add(currentNode._element);
                        currentNode._element = null;
                        headNode._nextNode = null;
                        headNode = currentNode;
                    }
                    n = count;
                    if (count <= 0) break block9;
                    this._headNode = headNode;
                    this._count.getAndAdd(-count);
                }
                catch (Throwable throwable) {
                    if (count > 0) {
                        this._headNode = headNode;
                        this._count.getAndAdd(-count);
                    }
                    throw throwable;
                }
            }
            return n;
        }
        finally {
            this._takeLock.unlock();
        }
    }

    public boolean isEmpty() {
        return this._count.get() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(E element, boolean[] hasWaiterMarker) {
        int count;
        block11: {
            if (element == null || hasWaiterMarker == null) {
                throw new NullPointerException();
            }
            if (hasWaiterMarker.length == 0) {
                throw new IllegalArgumentException();
            }
            if (this._count.get() == this._capacity) {
                return false;
            }
            count = -1;
            this._putLock.lock();
            try {
                count = this._count.get();
                if (count >= this._capacity) break block11;
                this._enqueue(element);
                if (this._count.getAndIncrement() == 0) {
                    this._takeLock.lock();
                    try {
                        this._notEmptyCondition.signal();
                    }
                    finally {
                        this._takeLock.unlock();
                    }
                }
                if (count >= this._count.get()) {
                    hasWaiterMarker[0] = true;
                }
            }
            finally {
                this._putLock.unlock();
            }
        }
        return count >= 0;
    }

    public E poll() {
        if (this._count.get() == 0) {
            return null;
        }
        E element = null;
        this._takeLock.lock();
        try {
            if (this._count.get() > 0) {
                element = this._dequeue();
                if (this._count.getAndDecrement() > 1) {
                    this._notEmptyCondition.signal();
                }
            }
        }
        finally {
            this._takeLock.unlock();
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E poll(long timeout, TimeUnit timeUnit) throws InterruptedException {
        E element = null;
        long nanos = timeUnit.toNanos(timeout);
        this._takeLock.lockInterruptibly();
        try {
            while (this._count.get() == 0) {
                if (nanos <= 0L) {
                    E e = null;
                    return e;
                }
                nanos = this._notEmptyCondition.awaitNanos(nanos);
            }
            element = this._dequeue();
            if (this._count.getAndDecrement() > 1) {
                this._notEmptyCondition.signal();
            }
        }
        finally {
            this._takeLock.unlock();
        }
        return element;
    }

    public int remainingCapacity() {
        return this._capacity - this._count.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(E element) {
        if (element == null) {
            return false;
        }
        this._fullyLock();
        try {
            Node<E> previousNode = this._headNode;
            Node currentNode = previousNode._nextNode;
            while (currentNode != null) {
                if (element.equals(currentNode._element)) {
                    this._unlink(currentNode, previousNode);
                    boolean bl = true;
                    return bl;
                }
                previousNode = currentNode;
                currentNode = currentNode._nextNode;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this._fullyUnlock();
        }
    }

    public int size() {
        return this._count.get();
    }

    public E take() throws InterruptedException {
        E element = null;
        this._takeLock.lockInterruptibly();
        try {
            while (this._count.get() == 0) {
                this._notEmptyCondition.await();
            }
            element = this._dequeue();
            if (this._count.getAndDecrement() > 1) {
                this._notEmptyCondition.signal();
            }
        }
        finally {
            this._takeLock.unlock();
        }
        return element;
    }

    protected ReentrantLock getPutLock() {
        return this._putLock;
    }

    protected ReentrantLock getTakeLock() {
        return this._takeLock;
    }

    private E _dequeue() {
        Node<E> headNode = this._headNode;
        Node firstNode = headNode._nextNode;
        headNode._nextNode = null;
        this._headNode = firstNode;
        Object element = firstNode._element;
        firstNode._element = null;
        return element;
    }

    private void _enqueue(E element) {
        this._tailNode._nextNode = new Node<E>(element);
        this._tailNode = this._tailNode._nextNode;
    }

    private void _fullyLock() {
        this._putLock.lock();
        this._takeLock.lock();
    }

    private void _fullyUnlock() {
        this._takeLock.unlock();
        this._putLock.unlock();
    }

    private void _unlink(Node<E> currentNode, Node<E> previousNode) {
        currentNode._element = null;
        previousNode._nextNode = currentNode._nextNode;
        if (this._tailNode == currentNode) {
            this._tailNode = previousNode;
        }
        this._count.getAndDecrement();
    }

    private static class Node<E> {
        private E _element;
        private Node<E> _nextNode;

        private Node(E element) {
            this._element = element;
        }
    }
}

