/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.content.security.policy;

import com.liferay.portal.kernel.content.security.policy.ContentSecurityPolicyNonceProvider;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import javax.servlet.http.HttpServletRequest;
import org.osgi.util.tracker.ServiceTracker;

public class ContentSecurityPolicyNonceProviderUtil {
    private static final Log _log = LogFactoryUtil.getLog(ContentSecurityPolicyNonceProviderUtil.class);
    private static final ServiceTracker<ContentSecurityPolicyNonceProvider, ContentSecurityPolicyNonceProvider> _serviceTracker = new ServiceTracker<ContentSecurityPolicyNonceProvider, ContentSecurityPolicyNonceProvider>(SystemBundleUtil.getBundleContext(), ContentSecurityPolicyNonceProvider.class, null){
        {
            this.open();
        }
    };

    public static ContentSecurityPolicyNonceProvider getContentSecurityPolicyNonceProvider() {
        return (ContentSecurityPolicyNonceProvider)_serviceTracker.getService();
    }

    public static String getNonce(HttpServletRequest httpServletRequest) {
        ContentSecurityPolicyNonceProvider contentSecurityPolicyNonceProvider = ContentSecurityPolicyNonceProviderUtil.getContentSecurityPolicyNonceProvider();
        if (contentSecurityPolicyNonceProvider == null) {
            _log.error("Content security policy nonce provider is null");
            return "";
        }
        return contentSecurityPolicyNonceProvider.getNonce(httpServletRequest);
    }

    public static String getNonceAttribute(HttpServletRequest httpServletRequest) {
        String nonce = ContentSecurityPolicyNonceProviderUtil.getNonce(httpServletRequest);
        if (Validator.isNull(nonce)) {
            return "";
        }
        return " nonce=\"" + nonce + "\"";
    }
}

