/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.dao.jdbc;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.ConnectionUtil;
import com.liferay.portal.kernel.dao.jdbc.MappingSqlQuery;
import com.liferay.portal.kernel.dao.jdbc.ParamSetter;
import com.liferay.portal.kernel.dao.jdbc.RowMapper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;

public class MappingSqlQueryImpl<T>
implements MappingSqlQuery<T> {
    private final DataSource _dataSource;
    private final ParamSetter[] _paramSetters;
    private final RowMapper<T> _rowMapper;
    private final String _sql;

    public MappingSqlQueryImpl(DataSource dataSource, String sql, RowMapper<T> rowMapper, ParamSetter ... paramSetters) {
        this._dataSource = dataSource;
        this._sql = sql;
        this._rowMapper = rowMapper;
        this._paramSetters = paramSetters;
    }

    @Override
    public List<T> execute(Object ... params) throws SQLException {
        if (this._paramSetters.length != params.length) {
            throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"Expected ", this._paramSetters.length, " parameters instead of ", params.length, " parameters"}));
        }
        try (Connection connection = ConnectionUtil.getConnection(this._dataSource);){
            ArrayList<T> arrayList;
            block24: {
                PreparedStatement preparedStatement = connection.prepareStatement(this._sql);
                try {
                    for (int i = 0; i < this._paramSetters.length; ++i) {
                        ParamSetter paramSetter = this._paramSetters[i];
                        paramSetter.set(preparedStatement, i + 1, params[i]);
                    }
                    List<T> results = null;
                    try (ResultSet resultSet = preparedStatement.executeQuery();){
                        while (resultSet.next()) {
                            if (results == null) {
                                results = new ArrayList<T>();
                            }
                            results.add(this._rowMapper.mapRow(resultSet));
                        }
                    }
                    if (results == null) {
                        results = Collections.emptyList();
                    }
                    arrayList = results;
                    if (preparedStatement == null) break block24;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return arrayList;
        }
    }
}

