/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.dao.jdbc;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.ConnectionUtil;
import com.liferay.portal.kernel.dao.jdbc.ParamSetter;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.sql.DataSource;

public class SqlUpdateImpl
implements SqlUpdate {
    private final DataSource _dataSource;
    private final ParamSetter[] _paramSetters;
    private final String _sql;

    public SqlUpdateImpl(DataSource dataSource, String sql, ParamSetter ... paramSetters) {
        this._dataSource = dataSource;
        this._sql = sql;
        this._paramSetters = paramSetters;
    }

    @Override
    public int update(Object ... params) throws SQLException {
        if (this._paramSetters.length != params.length) {
            throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"Expected ", this._paramSetters.length, " parameters instead of ", params.length, " parameters"}));
        }
        try (Connection connection = ConnectionUtil.getConnection(this._dataSource);){
            int n;
            block14: {
                PreparedStatement preparedStatement = connection.prepareStatement(this._sql);
                try {
                    for (int i = 0; i < this._paramSetters.length; ++i) {
                        ParamSetter paramSetter = this._paramSetters[i];
                        paramSetter.set(preparedStatement, i + 1, params[i]);
                    }
                    n = preparedStatement.executeUpdate();
                    if (preparedStatement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return n;
        }
    }
}

