/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.dependency.manager;

import com.liferay.portal.kernel.concurrent.DefaultNoticeableFuture;
import com.liferay.portal.kernel.concurrent.FutureListener;
import com.liferay.portal.kernel.concurrent.SystemExecutorServiceUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.SystemCheckerUtil;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;

public class DependencyManagerSyncUtil {
    private static final long _SYNC_TIMEOUT = GetterUtil.getInteger(PropsUtil.get("dependency.manager.sync.timeout"), 60);
    private static final Log _log = LogFactoryUtil.getLog(DependencyManagerSyncUtil.class);
    private static final DefaultNoticeableFuture<Void> _syncCallableDefaultNoticeableFuture = new DefaultNoticeableFuture();
    private static final DefaultNoticeableFuture<Void> _syncFutureTaskDefaultNoticeableFuture = new DefaultNoticeableFuture();

    public static void registerSyncCallable(Callable<?> syncCallable) {
        DependencyManagerSyncUtil._addFutureListener(_syncCallableDefaultNoticeableFuture, future -> {
            try {
                syncCallable.call();
            }
            catch (Exception exception) {
                _log.error("Unable to sync callable", exception);
            }
        });
    }

    public static void registerSyncFutureTask(FutureTask<?> syncFutureTask, String taskName) {
        DependencyManagerSyncUtil._addFutureListener(_syncFutureTaskDefaultNoticeableFuture, future -> {
            syncFutureTask.run();
            try {
                syncFutureTask.get(_SYNC_TIMEOUT, TimeUnit.SECONDS);
            }
            catch (Exception exception) {
                _log.error("Unable to sync future", exception);
            }
        });
        if (!syncFutureTask.isDone()) {
            ExecutorService systemExecutorService = SystemExecutorServiceUtil.getExecutorService();
            systemExecutorService.submit(SystemExecutorServiceUtil.renameThread(syncFutureTask, taskName));
        }
    }

    public static void sync() {
        if (_syncCallableDefaultNoticeableFuture.isDone()) {
            return;
        }
        _syncFutureTaskDefaultNoticeableFuture.run();
        _syncCallableDefaultNoticeableFuture.run();
        if (GetterUtil.getBoolean(PropsUtil.get("initial.system.check.enabled"), true)) {
            SystemCheckerUtil.runSystemCheckers(_log::info, _log::warn);
        }
    }

    private static void _addFutureListener(final DefaultNoticeableFuture<Void> defaultNoticeableFuture, final FutureListener<Void> futureListener) {
        defaultNoticeableFuture.addFutureListener(new FutureListener<Void>(){

            @Override
            public void complete(Future<Void> future) {
                futureListener.complete(future);
                defaultNoticeableFuture.removeFutureListener(this);
            }
        });
    }
}

