/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.encryptor;

import com.liferay.portal.kernel.encryptor.Encryptor;
import com.liferay.portal.kernel.encryptor.EncryptorException;
import com.liferay.portal.kernel.module.service.Snapshot;
import java.security.Key;

public class EncryptorUtil {
    private static final Snapshot<Encryptor> _encryptorSnapshot = new Snapshot<Encryptor>(EncryptorUtil.class, Encryptor.class);

    public static String decrypt(Key key, String encryptedString) throws EncryptorException {
        Encryptor encryptor = _encryptorSnapshot.get();
        return encryptor.decrypt(key, encryptedString);
    }

    public static byte[] decryptUnencodedAsBytes(Key key, byte[] encryptedBytes) throws EncryptorException {
        Encryptor encryptor = _encryptorSnapshot.get();
        return encryptor.decryptUnencodedAsBytes(key, encryptedBytes);
    }

    public static Key deserializeKey(String base64String) {
        Encryptor encryptor = _encryptorSnapshot.get();
        return encryptor.deserializeKey(base64String);
    }

    public static String encrypt(Key key, String plainText) throws EncryptorException {
        Encryptor encryptor = _encryptorSnapshot.get();
        return encryptor.encrypt(key, plainText);
    }

    public static byte[] encryptUnencoded(Key key, byte[] plainBytes) throws EncryptorException {
        Encryptor encryptor = _encryptorSnapshot.get();
        return encryptor.encryptUnencoded(key, plainBytes);
    }

    public static byte[] encryptUnencoded(Key key, String plainText) throws EncryptorException {
        Encryptor encryptor = _encryptorSnapshot.get();
        return encryptor.encryptUnencoded(key, plainText);
    }

    public static Key generateKey() throws EncryptorException {
        Encryptor encryptor = _encryptorSnapshot.get();
        return encryptor.generateKey();
    }

    public static String serializeKey(Key key) {
        Encryptor encryptor = _encryptorSnapshot.get();
        return encryptor.serializeKey(key);
    }
}

