/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.exception;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.FullNameValidator;
import com.liferay.portal.kernel.util.ClassUtil;

public class ContactNameException
extends PortalException {
    private ContactNameException(String msg) {
        super(msg);
    }

    public static class MustNotExceedMaximumLength
    extends ContactNameException {
        public MustNotExceedMaximumLength(int firstNameMaximumLength) {
            super(StringBundler.concat((Object[])new Object[]{"Contact first name must have fewer than ", firstNameMaximumLength, " characters"}));
        }
    }

    public static class MustHaveValidFullName
    extends ContactNameException {
        public final FullNameValidator fullNameValidator;

        public MustHaveValidFullName(FullNameValidator fullNameValidator) {
            super(String.format("Contact full name must validate with %s", ClassUtil.getClassName(fullNameValidator)));
            this.fullNameValidator = fullNameValidator;
        }
    }

    public static class MustHaveMiddleName
    extends ContactNameException {
        public MustHaveMiddleName() {
            super("Contact must have a middle name");
        }
    }

    public static class MustHaveLastName
    extends ContactNameException {
        public MustHaveLastName() {
            super("Contact must have a last name");
        }
    }

    public static class MustHaveFirstName
    extends ContactNameException {
        public MustHaveFirstName() {
            super("Contact must have a first name");
        }
    }
}

