/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.feature.flag;

import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.feature.flag.FeatureFlag;
import com.liferay.portal.kernel.feature.flag.constants.FeatureFlagConstants;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Locale;
import java.util.function.Predicate;

public enum FeatureFlagType {
    BETA("beta"),
    DEPRECATION("deprecation"),
    DEV("dev"),
    RELEASE("release");

    private static final Log _log;
    private final String _descriptionLanguageKey;
    private final String _titleLanguageKey;
    private final String _value;

    public static FeatureFlagType toFeatureFlagType(String string) {
        for (FeatureFlagType featureFlagType : FeatureFlagType.values()) {
            if (!StringUtil.equalsIgnoreCase(featureFlagType._value, string)) continue;
            return featureFlagType;
        }
        if (_log.isDebugEnabled()) {
            _log.debug("String did not match a known feature flag type");
        }
        return DEV;
    }

    public String getDescription(Locale locale) {
        return LanguageUtil.get(locale, this._descriptionLanguageKey);
    }

    public Predicate<FeatureFlag> getPredicate() {
        return featureFlag -> this.equals((Object)featureFlag.getFeatureFlagType());
    }

    public String getTitle(Locale locale) {
        return LanguageUtil.get(locale, this._titleLanguageKey);
    }

    public boolean isUIEnabled() {
        return GetterUtil.getBoolean(PropsUtil.get(FeatureFlagConstants.getKey("ui.visible"), new Filter(this._value)));
    }

    public String toString() {
        return this._value;
    }

    private FeatureFlagType(String value) {
        this._value = value;
        this._descriptionLanguageKey = FeatureFlagConstants.getKey("type.description", value);
        this._titleLanguageKey = FeatureFlagConstants.getKey("type.title", value);
    }

    static {
        _log = LogFactoryUtil.getLog(FeatureFlagType.class);
    }
}

