/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.Deserializer;
import com.liferay.portal.kernel.io.Serializer;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.TransientValue;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public class Message
implements Cloneable,
Serializable {
    private String _destinationName;
    private Object _payload;
    private Object _response;
    private String _responseDestinationName;
    private String _responseId;
    private Map<String, Object> _values;

    public static Message fromByteArray(byte[] bytes) throws ClassNotFoundException {
        Deserializer deserializer = new Deserializer(ByteBuffer.wrap(bytes));
        return (Message)deserializer.readObject();
    }

    public Message clone() {
        Message message = new Message();
        message._destinationName = this._destinationName;
        message._payload = this._payload;
        message._response = this._response;
        message._responseDestinationName = this._responseDestinationName;
        message._responseId = this._responseId;
        if (this._values != null) {
            message._values = new HashMap<String, Object>(this._values);
        }
        return message;
    }

    public boolean contains(String key) {
        if (this._values == null) {
            return false;
        }
        return this._values.containsKey(key);
    }

    public void copyFrom(Message message) {
        this._destinationName = message._destinationName;
        this._payload = message._payload;
        this._response = message._response;
        this._responseDestinationName = message._responseDestinationName;
        this._responseId = message._responseId;
        if (message._values != null) {
            this._values = new HashMap<String, Object>(message._values);
        }
    }

    public void copyTo(Message message) {
        message._destinationName = this._destinationName;
        message._payload = this._payload;
        message._response = this._response;
        message._responseDestinationName = this._responseDestinationName;
        message._responseId = this._responseId;
        if (this._values != null) {
            message._values = new HashMap<String, Object>(this._values);
        }
    }

    public Object get(String key) {
        if (this._values == null) {
            return null;
        }
        Object value = this._values.get(key);
        if (value instanceof TransientValue) {
            TransientValue transientValue = (TransientValue)value;
            value = transientValue.getValue();
        }
        return value;
    }

    public boolean getBoolean(String key) {
        boolean value = false;
        Object object = this.get(key);
        if (object instanceof Boolean) {
            Boolean booleanObj = (Boolean)object;
            value = booleanObj;
        } else {
            value = GetterUtil.getBoolean((String)object);
        }
        return value;
    }

    public String getDestinationName() {
        return this._destinationName;
    }

    public double getDouble(String key) {
        double value = 0.0;
        Object object = this.get(key);
        if (object instanceof Number) {
            Number number = (Number)object;
            value = number.doubleValue();
        } else {
            value = GetterUtil.getDouble((String)object);
        }
        return value;
    }

    public int getInteger(String key) {
        int value = 0;
        Object object = this.get(key);
        if (object instanceof Number) {
            Number number = (Number)object;
            value = number.intValue();
        } else {
            value = GetterUtil.getInteger((String)object);
        }
        return value;
    }

    public long getLong(String key) {
        long value = 0L;
        Object object = this.get(key);
        if (object instanceof Number) {
            Number number = (Number)object;
            value = number.longValue();
        } else {
            value = GetterUtil.getLong((String)object);
        }
        return value;
    }

    public Object getPayload() {
        return this._payload;
    }

    public Object getResponse() {
        return this._response;
    }

    public String getResponseDestinationName() {
        return this._responseDestinationName;
    }

    public String getResponseId() {
        return this._responseId;
    }

    public String getString(String key) {
        return GetterUtil.getString(String.valueOf(this.get(key)));
    }

    public Map<String, Object> getValues() {
        return this._values;
    }

    public void put(String key, Object value) {
        if (value == null) {
            if (this._values != null) {
                this._values.remove(key);
            }
            return;
        }
        if (this._values == null) {
            this._values = new HashMap<String, Object>();
        }
        if (!(value instanceof Serializable)) {
            value = new TransientValue<Object>(value);
        }
        this._values.put(key, value);
    }

    public void remove(String key) {
        if (this._values != null) {
            this._values.remove(key);
        }
    }

    public void setDestinationName(String destinationName) {
        this._destinationName = destinationName;
    }

    public void setPayload(Object payload) {
        this._payload = payload;
    }

    public void setResponse(Object response) {
        this._response = response;
    }

    public void setResponseDestinationName(String responseDestinationName) {
        this._responseDestinationName = responseDestinationName;
    }

    public void setResponseId(String responseId) {
        this._responseId = responseId;
    }

    public void setValues(Map<String, Object> values) {
        this._values = values;
    }

    public byte[] toByteArray() {
        Serializer serializer = new Serializer();
        serializer.writeObject(this);
        ByteBuffer byteBuffer = serializer.toByteBuffer();
        return byteBuffer.array();
    }

    public String toString() {
        return StringBundler.concat((Object[])new Object[]{"{destinationName=", this._destinationName, ", response=", this._response, ", responseDestinationName=", this._responseDestinationName, ", responseId=", this._responseId, ", payload=", this._payload, ", values=", MapUtil.toString(this._values, null, ".*[pP]assword.*"), "}"});
    }
}

