/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging.config;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationConfiguration;
import com.liferay.portal.kernel.messaging.DestinationFactory;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.messaging.config.MessagingConfigurator;
import com.liferay.portal.kernel.module.service.Snapshot;
import com.liferay.portal.kernel.module.util.ServiceLatch;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.MapUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class DefaultMessagingConfigurator
implements MessagingConfigurator {
    private static final Snapshot<DestinationFactory> _destinationFactorySnapshot = new Snapshot<DestinationFactory>(DefaultMessagingConfigurator.class, DestinationFactory.class);
    private final Set<DestinationConfiguration> _destinationConfigurations = new HashSet<DestinationConfiguration>();
    private final List<Destination> _destinations = new ArrayList<Destination>();
    private final Map<String, List<MessageListener>> _messageListeners = new HashMap<String, List<MessageListener>>();
    private final List<ServiceRegistration<?>> _serviceRegistrations = new ArrayList();

    public void afterPropertiesSet() {
        ServiceLatch serviceLatch = SystemBundleUtil.newServiceLatch();
        serviceLatch.waitFor(DestinationFactory.class);
        serviceLatch.waitFor(MessageBus.class);
        serviceLatch.openOn(this::initialize);
    }

    @Override
    public void destroy() {
        for (ServiceRegistration<?> serviceRegistration : this._serviceRegistrations) {
            serviceRegistration.unregister();
        }
        this._serviceRegistrations.clear();
        this._destinationConfigurations.clear();
        this._destinations.clear();
        this._messageListeners.clear();
    }

    @Override
    public void setDestinationConfigurations(Set<DestinationConfiguration> destinationConfigurations) {
        this._destinationConfigurations.addAll(destinationConfigurations);
    }

    @Override
    public void setDestinations(List<Destination> destinations) {
        this._destinations.addAll(destinations);
    }

    @Override
    public void setMessageListeners(Map<String, List<MessageListener>> messageListeners) {
        this._messageListeners.putAll(messageListeners);
    }

    protected void initialize() {
        this.registerDestinations();
        for (Map.Entry<String, List<MessageListener>> messageListeners : this._messageListeners.entrySet()) {
            String destinationName = messageListeners.getKey();
            ServiceLatch serviceLatch = SystemBundleUtil.newServiceLatch();
            serviceLatch.waitFor(StringBundler.concat((String[])new String[]{"(&(destination.name=", destinationName, ")(objectClass=", Destination.class.getName(), "))"}));
            serviceLatch.openOn(bundleContext -> {
                HashMapDictionary<String, String> properties = HashMapDictionaryBuilder.put("destination.name", destinationName).build();
                for (MessageListener messageListener : (List)messageListeners.getValue()) {
                    this._serviceRegistrations.add(bundleContext.registerService(MessageListener.class, (Object)messageListener, properties));
                }
            });
        }
    }

    protected void registerDestinations() {
        for (DestinationConfiguration destinationConfiguration : this._destinationConfigurations) {
            DestinationFactory destinationFactory = _destinationFactorySnapshot.get();
            this._destinations.add(destinationFactory.createDestination(destinationConfiguration));
        }
        if (this._destinations.isEmpty()) {
            return;
        }
        BundleContext bundleContext = SystemBundleUtil.getBundleContext();
        for (Destination destination : this._destinations) {
            this._serviceRegistrations.add(bundleContext.registerService(Destination.class, (Object)destination, MapUtil.singletonDictionary("destination.name", destination.getName())));
        }
    }
}

