/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.model;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.module.service.Snapshot;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.webserver.WebServerServletTokenUtil;
import com.liferay.users.admin.kernel.file.uploads.UserFileUploadsSettings;

public class UserConstants {
    public static final int FULL_NAME_MAX_LENGTH = 75;
    public static final String LIST_VIEW_FLAT_ORGANIZATIONS = "flat-organizations";
    public static final String LIST_VIEW_FLAT_USER_GROUPS = "flat-user-groups";
    public static final String LIST_VIEW_FLAT_USERS = "flat-users";
    public static final String LIST_VIEW_TREE = "tree";
    public static final String SCREEN_NAME_DEFAULT_SERVICE_ACCOUNT = "default-service-account";
    public static final int TYPE_DEFAULT_SERVICE_ACCOUNT = 2;
    public static final int TYPE_GUEST = 0;
    public static final int TYPE_ON_DEMAND_USER = 4;
    public static final int TYPE_REGULAR = 1;
    public static final int TYPE_SERVICE_ACCOUNT = 3;
    public static final long USER_ID_DEFAULT = 0L;
    public static final String USERS_EMAIL_ADDRESS_AUTO_SUFFIX = PropsUtil.get("users.email.address.auto.suffix");
    private static final Snapshot<UserFileUploadsSettings> _userFileUploadsSettingsSnapshot = new Snapshot<UserFileUploadsSettings>(UserConstants.class, UserFileUploadsSettings.class);

    public static String getPortraitURL(String imagePath, boolean male, long portraitId, String userUuid) {
        StringBundler sb = new StringBundler(8);
        sb.append(imagePath);
        boolean contactMaleEnabled = PrefsPropsUtil.getBoolean(CompanyThreadLocal.getCompanyId(), "field.enable.com.liferay.portal.kernel.model.Contact.male");
        if (contactMaleEnabled) {
            if (male) {
                sb.append("/user_male_portrait");
            } else {
                sb.append("/user_female_portrait");
            }
        } else {
            sb.append("/user_portrait");
        }
        sb.append("?img_id=");
        sb.append(portraitId);
        UserFileUploadsSettings userFileUploadsSettings = _userFileUploadsSettingsSnapshot.get();
        if (userFileUploadsSettings.isImageCheckToken()) {
            sb.append("&img_id_token=");
            sb.append(URLCodec.encodeURL(DigesterUtil.digest(userUuid)));
        }
        sb.append("&t=");
        sb.append(WebServerServletTokenUtil.getToken(portraitId));
        return sb.toString();
    }
}

