/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.model.dao;

import com.liferay.counter.kernel.service.CounterLocalServiceUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.model.ReleaseConstants;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;

public class ReleaseDAO {
    public void addRelease(Connection connection, String bundleSymbolicName) throws SQLException {
        if (this.hasRelease(connection, bundleSymbolicName)) {
            String schemaVersion = this._getSchemaVersion(connection, bundleSymbolicName);
            if (schemaVersion == null) {
                this._initSchemaVersion(connection, bundleSymbolicName);
            }
            return;
        }
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        try (PreparedStatement preparedStatement = connection.prepareStatement(StringBundler.concat((String[])new String[]{"insert into Release_ (mvccVersion, releaseId, ", "createDate, modifiedDate, servletContextName, ", "schemaVersion, buildNumber, buildDate, verified, state_, ", "testString) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"}));){
            preparedStatement.setLong(1, 0L);
            preparedStatement.setLong(2, this.increment());
            preparedStatement.setTimestamp(3, timestamp);
            preparedStatement.setTimestamp(4, timestamp);
            preparedStatement.setString(5, bundleSymbolicName);
            preparedStatement.setString(6, "0.0.1");
            preparedStatement.setInt(7, 1);
            preparedStatement.setTimestamp(8, timestamp);
            preparedStatement.setBoolean(9, false);
            preparedStatement.setInt(10, 0);
            preparedStatement.setString(11, ReleaseConstants.TEST_STRING);
            preparedStatement.execute();
        }
    }

    protected boolean hasRelease(Connection connection, String bundleSymbolicName) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("select * from Release_ where servletContextName = ?");){
            boolean bl;
            block12: {
                preparedStatement.setString(1, bundleSymbolicName);
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    bl = resultSet.next();
                    if (resultSet == null) break block12;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return bl;
        }
    }

    protected long increment() {
        return CounterLocalServiceUtil.increment();
    }

    private String _getSchemaVersion(Connection connection, String bundleSymbolicName) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("select schemaVersion from Release_ where servletContextName = ?");){
            String string;
            block16: {
                ResultSet resultSet;
                block14: {
                    String string2;
                    block15: {
                        preparedStatement.setString(1, bundleSymbolicName);
                        resultSet = preparedStatement.executeQuery();
                        try {
                            if (!resultSet.next()) break block14;
                            string2 = resultSet.getString(1);
                            if (resultSet == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    return string2;
                }
                string = null;
                if (resultSet == null) break block16;
                resultSet.close();
            }
            return string;
        }
    }

    private void _initSchemaVersion(Connection connection, String bundleSymbolicName) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("update Release_ set schemaVersion = '0.0.1' where servletContextName = ?");){
            preparedStatement.setString(1, bundleSymbolicName);
            preparedStatement.executeUpdate();
        }
    }
}

