/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletPreferences;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletLayoutFinder;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.sites.kernel.util.SitesUtil;
import java.util.List;

public abstract class BasePortletLayoutFinder
implements PortletLayoutFinder {
    private static final Log _log = LogFactoryUtil.getLog(BasePortletLayoutFinder.class);

    @Override
    public PortletLayoutFinder.Result find(ThemeDisplay themeDisplay, long groupId) throws PortalException {
        Object[] scopePlidAndPortletId;
        String[] portletIds;
        block6: {
            portletIds = this.getPortletIds();
            if (themeDisplay.getPlid() != 0L && groupId == themeDisplay.getScopeGroupId()) {
                try {
                    Layout layout = LayoutLocalServiceUtil.getLayout(themeDisplay.getPlid());
                    LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
                    for (String portletId : portletIds) {
                        if (!layoutTypePortlet.hasPortletId(portletId, false) || !LayoutPermissionUtil.contains(themeDisplay.getPermissionChecker(), layout, "VIEW")) continue;
                        portletId = this.getPortletId(layoutTypePortlet, portletId);
                        return new ResultImpl(themeDisplay.getPlid(), portletId, false);
                    }
                }
                catch (NoSuchLayoutException noSuchLayoutException) {
                    if (!_log.isDebugEnabled()) break block6;
                    _log.debug(noSuchLayoutException);
                }
            }
        }
        Object[] plidAndPortletId = this._fetchPlidAndPortletId(themeDisplay.getPermissionChecker(), groupId, portletIds);
        Group scopeGroup = themeDisplay.getScopeGroup();
        if ((plidAndPortletId == null || ((Boolean)plidAndPortletId[2]).booleanValue()) && (scopeGroup.isSite() || SitesUtil.isUserGroupLayoutSetViewable(themeDisplay.getPermissionChecker(), scopeGroup)) && (scopePlidAndPortletId = this._fetchPlidAndPortletId(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), portletIds)) != null) {
            plidAndPortletId = scopePlidAndPortletId;
        }
        if (plidAndPortletId == null) {
            throw new NoSuchLayoutException(this._getErrorMessage(groupId, themeDisplay, portletIds));
        }
        return new ResultImpl((Long)plidAndPortletId[0], (String)plidAndPortletId[1], (Boolean)plidAndPortletId[2]);
    }

    protected String getPortletId(LayoutTypePortlet layoutTypePortlet, String portletId) {
        for (Portlet curPortlet : layoutTypePortlet.getAllNonembeddedPortlets()) {
            String curRootPortletId = PortletIdCodec.decodePortletName(curPortlet.getPortletId());
            if (!portletId.equals(curRootPortletId)) continue;
            return curPortlet.getPortletId();
        }
        Layout layout = layoutTypePortlet.getLayout();
        List<PortletPreferences> layoutPortletPreferences = PortletPreferencesLocalServiceUtil.getPortletPreferences(3, layout.getPlid(), portletId);
        if (!layoutPortletPreferences.isEmpty()) {
            PortletPreferences portletPreferences = layoutPortletPreferences.get(0);
            return portletPreferences.getPortletId();
        }
        return null;
    }

    protected abstract String[] getPortletIds();

    private Object[] _fetchPlidAndPortletId(PermissionChecker permissionChecker, long groupId, String[] portletIds) throws PortalException {
        Object[] fallbackPlidAndPortletId = null;
        for (String curPortletId : portletIds) {
            long plid = PortalUtil.getPlidFromPortletId(groupId, curPortletId);
            if (plid == 0L) continue;
            Layout layout = LayoutLocalServiceUtil.getLayout(plid);
            LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
            String portletId = this.getPortletId(layoutTypePortlet, curPortletId);
            if (!LayoutPermissionUtil.contains(permissionChecker, LayoutLocalServiceUtil.getLayout(plid), "VIEW") && !permissionChecker.isSignedIn()) {
                fallbackPlidAndPortletId = new Object[]{plid, portletId, true};
                continue;
            }
            return new Object[]{plid, portletId, false};
        }
        return fallbackPlidAndPortletId;
    }

    private String _getErrorMessage(long groupId, ThemeDisplay themeDisplay, String[] portletIds) {
        StringBundler sb = new StringBundler(portletIds.length * 2 + 5);
        sb.append("{groupId=");
        sb.append(groupId);
        sb.append(", plid=");
        sb.append(themeDisplay.getPlid());
        for (String portletId : portletIds) {
            sb.append(", portletId=");
            sb.append(portletId);
        }
        sb.append("}");
        return sb.toString();
    }

    protected class ResultImpl
    implements PortletLayoutFinder.Result {
        private final long _plid;
        private final String _portletId;
        private final boolean _signInRequired;

        public ResultImpl(long plid, String portletId, boolean signInRequired) {
            this._plid = plid;
            this._portletId = portletId;
            this._signInRequired = signInRequired;
        }

        @Override
        public long getPlid() {
            return this._plid;
        }

        @Override
        public String getPortletId() {
            return this._portletId;
        }

        @Override
        public boolean isSignInRequired() {
            return this._signInRequired;
        }
    }
}

