/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet;

import com.liferay.portal.kernel.util.ArrayUtil;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.portlet.RenderRequest;
import javax.portlet.filter.RenderRequestWrapper;

public class DynamicRenderRequest
extends RenderRequestWrapper {
    private final boolean _inherit;
    private final Map<String, String[]> _params;

    public DynamicRenderRequest(RenderRequest renderRequest) {
        this(renderRequest, null, true);
    }

    public DynamicRenderRequest(RenderRequest renderRequest, boolean inherit) {
        this(renderRequest, null, inherit);
    }

    public DynamicRenderRequest(RenderRequest renderRequest, Map<String, String[]> params) {
        this(renderRequest, params, true);
    }

    public DynamicRenderRequest(RenderRequest renderRequest, Map<String, String[]> params, boolean inherit) {
        super(renderRequest);
        this._inherit = inherit;
        this._params = new HashMap<String, String[]>();
        if (params != null) {
            this._params.putAll(params);
        }
        if (this._inherit && renderRequest instanceof DynamicRenderRequest) {
            DynamicRenderRequest dynamicRenderRequest = (DynamicRenderRequest)renderRequest;
            this.setRequest(dynamicRenderRequest.getRequest());
            params = dynamicRenderRequest.getDynamicParameterMap();
            for (Map.Entry<String, String[]> entry : params.entrySet()) {
                String name = entry.getKey();
                String[] oldValues = entry.getValue();
                String[] curValues = this._params.get(name);
                if (curValues == null) {
                    this._params.put(name, oldValues);
                    continue;
                }
                String[] newValues = ArrayUtil.append(oldValues, curValues);
                this._params.put(name, newValues);
            }
        }
    }

    public Map<String, String[]> getDynamicParameterMap() {
        return this._params;
    }

    public String getParameter(String name) {
        Object[] values = this._params.get(name);
        if (this._inherit && values == null) {
            return super.getParameter(name);
        }
        if (ArrayUtil.isNotEmpty(values)) {
            return values[0];
        }
        return null;
    }

    public Map<String, String[]> getParameterMap() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        if (this._inherit) {
            map.putAll(super.getParameterMap());
        }
        map.putAll(this._params);
        return map;
    }

    public Enumeration<String> getParameterNames() {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        if (this._inherit) {
            Enumeration enumeration = super.getParameterNames();
            while (enumeration.hasMoreElements()) {
                names.add((String)enumeration.nextElement());
            }
        }
        names.addAll(this._params.keySet());
        return Collections.enumeration(names);
    }

    public String[] getParameterValues(String name) {
        String[] values = this._params.get(name);
        if (this._inherit && values == null) {
            return super.getParameterValues(name);
        }
        return values;
    }

    public void setParameter(String name, String value) {
        this._params.put(name, new String[]{value});
    }

    public void setParameterValues(String name, String[] values) {
        this._params.put(name, values);
    }
}

