/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet;

import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.portlet.FriendlyURLResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.osgi.framework.BundleContext;

public class FriendlyURLResolverRegistryUtil {
    private static final BundleContext _bundleContext = SystemBundleUtil.getBundleContext();
    private static final ServiceTrackerList<FriendlyURLResolver> _serviceTrackerList = ServiceTrackerListFactory.open((BundleContext)_bundleContext, FriendlyURLResolver.class);

    public static FriendlyURLResolver getFriendlyURLResolver(String urlSeparator) {
        for (FriendlyURLResolver friendlyURLResolver : _serviceTrackerList) {
            if (!Objects.equals(friendlyURLResolver.getURLSeparator(), urlSeparator)) continue;
            return friendlyURLResolver;
        }
        return null;
    }

    public static FriendlyURLResolver getFriendlyURLResolverByDefaultURLSeparator(String defaultURLSeparator) {
        for (FriendlyURLResolver friendlyURLResolver : _serviceTrackerList) {
            if (!Objects.equals(friendlyURLResolver.getDefaultURLSeparator(), defaultURLSeparator)) continue;
            return friendlyURLResolver;
        }
        return null;
    }

    public static Collection<FriendlyURLResolver> getFriendlyURLResolversAsCollection() {
        return _serviceTrackerList.toList();
    }

    public static String[] getURLSeparators() {
        ArrayList<String> urlSeparators = new ArrayList<String>();
        for (FriendlyURLResolver friendlyURLResolver : _serviceTrackerList) {
            if (friendlyURLResolver == null) continue;
            urlSeparators.add(friendlyURLResolver.getURLSeparator());
        }
        return urlSeparators.toArray(new String[0]);
    }
}

