/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;
import org.osgi.framework.BundleContext;

public class PortletProviderUtil {
    private static final ServiceTrackerMap<String, List<PortletProvider>> _serviceTrackerMap = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)SystemBundleUtil.getBundleContext(), PortletProvider.class, (String)"model.class.name");

    public static String getPortletId(String className, PortletProvider.Action action) {
        PortletProvider portletProvider = PortletProviderUtil._getPortletProvider(className, action);
        if (portletProvider != null) {
            return portletProvider.getPortletName();
        }
        return "";
    }

    public static PortletURL getPortletURL(HttpServletRequest httpServletRequest, Group group, String className, PortletProvider.Action action) throws PortalException {
        PortletProvider portletProvider = PortletProviderUtil._getPortletProvider(className, action);
        if (portletProvider != null) {
            return portletProvider.getPortletURL(httpServletRequest, group);
        }
        return null;
    }

    public static PortletURL getPortletURL(HttpServletRequest httpServletRequest, String className, PortletProvider.Action action) throws PortalException {
        PortletProvider portletProvider = PortletProviderUtil._getPortletProvider(className, action);
        if (portletProvider != null) {
            return portletProvider.getPortletURL(httpServletRequest);
        }
        return null;
    }

    public static PortletURL getPortletURL(PortletRequest portletRequest, Group group, String className, PortletProvider.Action action) throws PortalException {
        return PortletProviderUtil.getPortletURL(PortalUtil.getHttpServletRequest(portletRequest), group, className, action);
    }

    public static PortletURL getPortletURL(PortletRequest portletRequest, String className, PortletProvider.Action action) throws PortalException {
        return PortletProviderUtil.getPortletURL(PortalUtil.getHttpServletRequest(portletRequest), className, action);
    }

    private static PortletProvider _getPortletProvider(PortletProvider.Action action, List<PortletProvider> portletProviders) {
        if (portletProviders == null) {
            return null;
        }
        for (PortletProvider portletProvider : portletProviders) {
            if (!ArrayUtil.contains((Object[])portletProvider.getSupportedActions(), (Object)action)) continue;
            return portletProvider;
        }
        return null;
    }

    private static PortletProvider _getPortletProvider(String className, PortletProvider.Action action) {
        PortletProvider portletProvider = PortletProviderUtil._getPortletProvider(action, (List)_serviceTrackerMap.getService((Object)className));
        if (portletProvider == null && PortletProviderUtil._isAssetObject(className)) {
            portletProvider = PortletProviderUtil._getPortletProvider(action, (List)_serviceTrackerMap.getService((Object)AssetEntry.class.getName()));
        }
        return portletProvider;
    }

    private static boolean _isAssetObject(String className) {
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName(className);
        return assetRendererFactory != null;
    }
}

