/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet.render;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.content.security.policy.ContentSecurityPolicyNonceProviderUtil;
import com.liferay.portal.kernel.frontend.esm.FrontendESMUtil;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.portlet.render.PortletRenderParts;
import com.liferay.portal.kernel.portlet.render.PortletResourceAccessor;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PortletRenderUtil {
    private static final PortletResourceAccessor _FOOTER_PORTAL_CSS = new PortletResourceAccessor(true){

        @Override
        public Collection<String> get(Portlet portlet) {
            return portlet.getFooterPortalCss();
        }
    };
    private static final PortletResourceAccessor _FOOTER_PORTAL_JS = new PortletResourceAccessor(true){

        @Override
        public Collection<String> get(Portlet portlet) {
            return portlet.getFooterPortalJavaScript();
        }
    };
    private static final PortletResourceAccessor _FOOTER_PORTLET_CSS = new PortletResourceAccessor(false){

        @Override
        public Collection<String> get(Portlet portlet) {
            return portlet.getFooterPortletCss();
        }
    };
    private static final PortletResourceAccessor _FOOTER_PORTLET_JS = new PortletResourceAccessor(false){

        @Override
        public Collection<String> get(Portlet portlet) {
            return portlet.getFooterPortletJavaScript();
        }
    };
    private static final PortletResourceAccessor _HEADER_PORTAL_CSS = new PortletResourceAccessor(true){

        @Override
        public Collection<String> get(Portlet portlet) {
            return portlet.getHeaderPortalCss();
        }
    };
    private static final PortletResourceAccessor _HEADER_PORTAL_JS = new PortletResourceAccessor(true){

        @Override
        public Collection<String> get(Portlet portlet) {
            return portlet.getHeaderPortalJavaScript();
        }
    };
    private static final PortletResourceAccessor _HEADER_PORTLET_CSS = new PortletResourceAccessor(false){

        @Override
        public Collection<String> get(Portlet portlet) {
            return portlet.getHeaderPortletCss();
        }
    };
    private static final PortletResourceAccessor _HEADER_PORTLET_JS = new PortletResourceAccessor(false){

        @Override
        public Collection<String> get(Portlet portlet) {
            return portlet.getHeaderPortletJavaScript();
        }
    };
    private static final Set<String> _specialPrefixes = SetUtil.fromArray("module:", "nocombo:");

    public static PortletRenderParts getPortletRenderParts(HttpServletRequest httpServletRequest, String portletHTML, Portlet portlet) {
        boolean portletOnLayout = false;
        if (portlet.isInstanceable()) {
            String rootPortletId = PortletRenderUtil._getRootPortletId(portlet);
            String portletId = portlet.getPortletId();
            for (Portlet layoutPortlet : PortletRenderUtil._getAllPortlets(httpServletRequest)) {
                String layoutPortletRootPortletId = PortletRenderUtil._getRootPortletId(layoutPortlet);
                if (!rootPortletId.equals(layoutPortletRootPortletId) || portletId.equals(layoutPortlet.getPortletId())) continue;
                portletOnLayout = true;
                break;
            }
        }
        return PortletRenderUtil._getPortletRenderParts(httpServletRequest, portletHTML, portlet, portletOnLayout);
    }

    public static void writeFooterCSSPaths(HttpServletRequest httpServletRequest, Collection<Portlet> portlets, Writer writer) {
        Collection<String> urls = PortletRenderUtil._getURLs(httpServletRequest, Arrays.asList(_FOOTER_PORTAL_CSS, _FOOTER_PORTLET_CSS), portlets, URLType.CSS);
        for (String url : urls) {
            PortletRenderUtil._writeCSSPath(new PrintWriter(writer, true), url, null);
        }
    }

    public static void writeFooterJavaScriptPaths(HttpServletRequest httpServletRequest, Collection<Portlet> portlets, Writer writer) {
        Collection<String> urls = PortletRenderUtil._getURLs(httpServletRequest, Arrays.asList(_FOOTER_PORTAL_JS, _FOOTER_PORTLET_JS), portlets, URLType.JAVASCRIPT);
        for (String url : urls) {
            PortletRenderUtil._writeJavaScriptPath(new PrintWriter(writer, true), url, null);
        }
    }

    public static void writeFooterPaths(HttpServletResponse httpServletResponse, PortletRenderParts portletRenderParts) throws IOException {
        PortletRenderUtil._writePaths(httpServletResponse, portletRenderParts.getFooterCssPaths(), portletRenderParts.getFooterJavaScriptPaths());
    }

    public static void writeHeaderCSSPaths(HttpServletRequest httpServletRequest, Collection<Portlet> portlets, Writer writer) {
        Collection<String> urls = PortletRenderUtil._getURLs(httpServletRequest, Arrays.asList(_HEADER_PORTAL_CSS, _HEADER_PORTLET_CSS), portlets, URLType.CSS);
        for (String url : urls) {
            PortletRenderUtil._writeCSSPath(new PrintWriter(writer, true), url, HashMapBuilder.put("data-senna-track", "temporary").put("id", HtmlUtil.escapeAttribute(StringUtil.toHexString(url.hashCode()))).build());
        }
    }

    public static void writeHeaderJavaScriptPaths(HttpServletRequest httpServletRequest, Collection<Portlet> portlets, Writer writer) {
        Collection<String> urls = PortletRenderUtil._getURLs(httpServletRequest, Arrays.asList(_HEADER_PORTAL_JS, _HEADER_PORTLET_JS), portlets, URLType.JAVASCRIPT);
        for (String url : urls) {
            PortletRenderUtil._writeJavaScriptPath(new PrintWriter(writer, true), url, Collections.singletonMap("data-senna-track", "temporary"));
        }
    }

    public static void writeHeaderPaths(HttpServletResponse httpServletResponse, PortletRenderParts portletRenderParts) throws IOException {
        PortletRenderUtil._writePaths(httpServletResponse, portletRenderParts.getHeaderCssPaths(), portletRenderParts.getHeaderJavaScriptPaths());
    }

    private static List<Portlet> _getAllPortlets(HttpServletRequest httpServletRequest) {
        List<Portlet> allPortlets = (List<Portlet>)httpServletRequest.getAttribute("ALL_PORTLETS");
        if (ListUtil.isNotEmpty(allPortlets)) {
            return allPortlets;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        LayoutTypePortlet layoutTypePortlet = themeDisplay.getLayoutTypePortlet();
        allPortlets = layoutTypePortlet.getAllPortlets();
        httpServletRequest.setAttribute("ALL_PORTLETS", allPortlets);
        return allPortlets;
    }

    /*
     * WARNING - void declaration
     */
    private static List<String> _getComboServletURLs(Collection<PortletResourceAccessor> portletResourceAccessors, Collection<Portlet> portlets, Predicate<String> predicate, long timestamp, String urlPrefix, Set<String> visitedURLs) {
        if (predicate == null) {
            predicate = s -> true;
        }
        ArrayList<String> urls = new ArrayList<String>();
        StringBundler comboServletSB = new StringBundler();
        for (Portlet portlet : portlets) {
            for (PortletResourceAccessor portletResourceAccessor : portletResourceAccessors) {
                Object contextPath = null;
                contextPath = portletResourceAccessor.isPortalResource() ? PortalUtil.getPathContext() : PortalUtil.getPathProxy() + portlet.getContextPath();
                Collection<String> portletResources = portletResourceAccessor.get(portlet);
                for (String string : portletResources) {
                    void var16_15;
                    void var16_18;
                    boolean absolute;
                    if (!predicate.test(string)) continue;
                    String prefix = null;
                    for (String specialPrefix : _specialPrefixes) {
                        if (!string.startsWith(specialPrefix)) continue;
                        String string2 = string.substring(specialPrefix.length());
                        prefix = specialPrefix;
                        break;
                    }
                    if (!(absolute = HttpComponentsUtil.hasProtocol((String)var16_18))) {
                        String string3 = (String)contextPath + (String)var16_18;
                    }
                    if (Validator.isNotNull(prefix)) {
                        void var16_20;
                        String string4 = prefix + (String)var16_20;
                    }
                    if (visitedURLs.contains(var16_15)) continue;
                    visitedURLs.add((String)var16_15);
                    if (absolute || Validator.isNotNull(prefix)) {
                        urls.add((String)var16_15);
                        continue;
                    }
                    comboServletSB.append("&");
                    if (!portletResourceAccessor.isPortalResource()) {
                        comboServletSB.append(portlet.getPortletId());
                        comboServletSB.append(":");
                    }
                    comboServletSB.append(HtmlUtil.escapeURL((String)var16_15));
                    timestamp = Math.max(timestamp, portlet.getTimestamp());
                }
            }
        }
        if (comboServletSB.length() > 0) {
            Object url = urlPrefix + comboServletSB;
            url = HttpComponentsUtil.addParameter((String)url, "t", timestamp);
            urls.add((String)url);
        }
        return urls;
    }

    private static String _getMinifierType(URLType urlType) {
        if (urlType == URLType.CSS) {
            return "css";
        }
        return "js";
    }

    private static PortletRenderParts _getPortletRenderParts(HttpServletRequest httpServletRequest, String portletHTML, Portlet portlet, boolean portletOnLayout) {
        Collection<String> footerCssPaths = Collections.emptyList();
        Collection<String> footerJavaScriptPaths = Collections.emptyList();
        Collection<String> headerCssPaths = Collections.emptyList();
        Collection<String> headerJavaScriptPaths = Collections.emptyList();
        if (!portletOnLayout && portlet.isAjaxable()) {
            footerCssPaths = PortletRenderUtil._getURLs(httpServletRequest, Arrays.asList(_FOOTER_PORTLET_CSS, _FOOTER_PORTAL_CSS), Arrays.asList(portlet), URLType.CSS);
            footerJavaScriptPaths = PortletRenderUtil._getURLs(httpServletRequest, Arrays.asList(_FOOTER_PORTLET_JS, _FOOTER_PORTAL_JS), Arrays.asList(portlet), URLType.JAVASCRIPT);
            headerCssPaths = PortletRenderUtil._getURLs(httpServletRequest, Arrays.asList(_HEADER_PORTLET_CSS, _HEADER_PORTAL_CSS), Arrays.asList(portlet), URLType.CSS);
            headerJavaScriptPaths = PortletRenderUtil._getURLs(httpServletRequest, Arrays.asList(_HEADER_PORTLET_JS, _HEADER_PORTAL_JS), Arrays.asList(portlet), URLType.JAVASCRIPT);
        }
        return new PortletRenderParts(footerCssPaths, footerJavaScriptPaths, headerCssPaths, headerJavaScriptPaths, portletHTML, !portlet.isAjaxable());
    }

    private static String _getRootPortletId(Portlet portlet) {
        Portlet rootPortlet = portlet.getRootPortlet();
        return rootPortlet.getPortletId();
    }

    /*
     * WARNING - void declaration
     */
    private static List<String> _getStaticURLs(HttpServletRequest httpServletRequest, Collection<PortletResourceAccessor> portletResourceAccessors, Collection<Portlet> portlets, Set<String> visitedURLs) {
        ArrayList<String> urls = new ArrayList<String>();
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        for (Portlet portlet : portlets) {
            Portlet rootPortlet = portlet.getRootPortlet();
            for (PortletResourceAccessor portletResourceAccessor : portletResourceAccessors) {
                Object contextPath = null;
                contextPath = portletResourceAccessor.isPortalResource() ? PortalUtil.getPathContext() : PortalUtil.getPathProxy() + portlet.getContextPath();
                Collection<String> portletResources = portletResourceAccessor.get(portlet);
                for (String string : portletResources) {
                    void var14_14;
                    void var14_19;
                    void var14_17;
                    String prefix = null;
                    for (String specialProtocol : _specialPrefixes) {
                        if (!string.startsWith(specialProtocol)) continue;
                        String string2 = string.substring(specialProtocol.length());
                        prefix = specialProtocol;
                        break;
                    }
                    if (!HttpComponentsUtil.hasProtocol((String)var14_17)) {
                        String string3 = PortalUtil.getStaticResourceURL(httpServletRequest, (String)contextPath + (String)var14_17, rootPortlet.getTimestamp());
                    }
                    if (!var14_19.contains("://")) {
                        String cdnBaseURL = themeDisplay.getCDNBaseURL();
                        String string4 = cdnBaseURL.concat((String)var14_19);
                    }
                    if (Validator.isNotNull(prefix)) {
                        void var14_21;
                        String string5 = prefix + (String)var14_21;
                    }
                    if (visitedURLs.contains(var14_14)) continue;
                    visitedURLs.add((String)var14_14);
                    urls.add((String)var14_14);
                }
            }
        }
        return urls;
    }

    private static Collection<String> _getURLs(HttpServletRequest httpServletRequest, Collection<PortletResourceAccessor> portletResourceAccessors, Collection<Portlet> portlets, URLType urlType) {
        boolean fastLoad;
        Predicate<String> predicate = null;
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (urlType == URLType.CSS) {
            fastLoad = themeDisplay.isThemeCssFastLoad();
        } else if (urlType == URLType.JAVASCRIPT) {
            fastLoad = themeDisplay.isThemeJsFastLoad();
            predicate = resource -> !themeDisplay.isIncludedJs((String)resource);
        } else {
            throw new UnsupportedOperationException("Unsupported URL type " + urlType);
        }
        LinkedHashSet<String> visitedURLs = (LinkedHashSet<String>)httpServletRequest.getAttribute("LIFERAY_SHARED_PORTLET_RESOURCE_STATIC_URLS");
        if (visitedURLs == null) {
            visitedURLs = new LinkedHashSet<String>();
            httpServletRequest.setAttribute("LIFERAY_SHARED_PORTLET_RESOURCE_STATIC_URLS", visitedURLs);
        }
        List<String> urls = null;
        if (fastLoad) {
            Theme theme = themeDisplay.getTheme();
            urls = PortletRenderUtil._getComboServletURLs(portletResourceAccessors, portlets, predicate, theme.getTimestamp(), PortalUtil.getStaticResourceURL(httpServletRequest, themeDisplay.getCDNDynamicResourcesHost() + themeDisplay.getPathContext() + "/combo", StringBundler.concat((String[])new String[]{"minifierType=", PortletRenderUtil._getMinifierType(urlType), "&themeId=", themeDisplay.getThemeId()}), -1L), visitedURLs);
        } else {
            urls = PortletRenderUtil._getStaticURLs(httpServletRequest, portletResourceAccessors, portlets, visitedURLs);
        }
        for (int i = 0; i < urls.size(); ++i) {
            String url = urls.get(i);
            if (!url.startsWith("nocombo:")) continue;
            urls.set(i, url.substring(8));
        }
        return urls;
    }

    private static void _writeCSSPath(PrintWriter printWriter, String cssPath, Map<String, String> attributes) {
        printWriter.print("<link href=\"");
        printWriter.print(HtmlUtil.escape(cssPath));
        printWriter.print("\"");
        printWriter.print(ContentSecurityPolicyNonceProviderUtil.getNonceAttribute(null));
        printWriter.println(" rel=\"stylesheet\" type=\"text/css\"");
        if (attributes != null) {
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                printWriter.print(" ");
                printWriter.print(entry.getKey());
                printWriter.print("=\"");
                printWriter.print(HtmlUtil.escapeAttribute(entry.getValue()));
                printWriter.print("\"");
            }
        }
        printWriter.println(" />");
    }

    private static void _writeJavaScriptPath(PrintWriter printWriter, String javaScriptPath, Map<String, String> attributes) {
        String type = "text/javascript";
        if (javaScriptPath.startsWith("module:")) {
            javaScriptPath = javaScriptPath.substring(7);
            type = FrontendESMUtil.getScriptType();
        }
        printWriter.print("<script");
        printWriter.print(ContentSecurityPolicyNonceProviderUtil.getNonceAttribute(null));
        printWriter.print(" src=\"");
        printWriter.print(HtmlUtil.escapeAttribute(javaScriptPath));
        printWriter.print("\" type=\"");
        printWriter.print(type);
        printWriter.print("\"");
        if (attributes != null) {
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                printWriter.print(" ");
                printWriter.print(entry.getKey());
                printWriter.print("=\"");
                printWriter.print(HtmlUtil.escapeAttribute(entry.getValue()));
                printWriter.print("\"");
            }
        }
        printWriter.println("></script>");
    }

    private static void _writePaths(HttpServletResponse httpServletResponse, Collection<String> cssPaths, Collection<String> javaScriptPaths) throws IOException {
        if (cssPaths == null || javaScriptPaths == null || cssPaths.isEmpty() && javaScriptPaths.isEmpty()) {
            return;
        }
        PrintWriter printWriter = httpServletResponse.getWriter();
        for (String cssPath : cssPaths) {
            PortletRenderUtil._writeCSSPath(printWriter, cssPath, null);
        }
        for (String javaScriptPath : javaScriptPaths) {
            PortletRenderUtil._writeJavaScriptPath(printWriter, javaScriptPath, null);
        }
    }

    private static enum URLType {
        CSS,
        JAVASCRIPT;

    }
}

