/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet.url.builder;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.util.Validator;
import javax.portlet.ActionResponse;
import javax.portlet.MimeResponse;
import javax.portlet.MutableRenderParameters;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletParameters;
import javax.portlet.PortletSecurityException;
import javax.portlet.RenderURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import javax.portlet.annotations.PortletSerializable;

public class RenderURLBuilder {
    public static RenderURLStep createRedirectURL(ActionResponse actionResponse, MimeResponse.Copy copy) {
        return new RenderURLStep(actionResponse.createRedirectURL(copy));
    }

    public static RenderURLStep createRenderURL(LiferayPortletResponse liferayPortletResponse) {
        return new RenderURLStep((RenderURL)liferayPortletResponse.createRenderURL());
    }

    public static RenderURLStep createRenderURL(LiferayPortletResponse liferayPortletResponse, MimeResponse.Copy copy) {
        return new RenderURLStep(liferayPortletResponse.createRenderURL(copy));
    }

    public static RenderURLStep createRenderURL(LiferayPortletResponse liferayPortletResponse, String portletName) {
        return new RenderURLStep((RenderURL)liferayPortletResponse.createRenderURL(portletName));
    }

    public static RenderURLStep createRenderURL(LiferayPortletResponse liferayPortletResponse, String portletName, MimeResponse.Copy copy) {
        return new RenderURLStep((RenderURL)liferayPortletResponse.createRenderURL(portletName, copy));
    }

    public static RenderURLStep createRenderURL(MimeResponse mimeResponse) {
        return new RenderURLStep((RenderURL)mimeResponse.createRenderURL());
    }

    public static RenderURLStep createRenderURL(MimeResponse mimeResponse, MimeResponse.Copy copy) {
        return new RenderURLStep(mimeResponse.createRenderURL(copy));
    }

    public static RenderURLStep createRenderURL(RenderURL renderURL) {
        return new RenderURLStep(renderURL);
    }

    public static class RenderURLStep
    implements AfterBackURLStep,
    AfterBeanParameterStep,
    AfterCMDStep,
    AfterFragmentIdentifierStep,
    AfterKeywordsStep,
    AfterMVCPathStep,
    AfterMVCRenderCommandNameStep,
    AfterNavigationStep,
    AfterParameterStep,
    AfterPortletModeStep,
    AfterPortletResourceStep,
    AfterRedirectStep,
    AfterSecureStep,
    AfterTabs1Step,
    AfterTabs2Step,
    AfterWindowStateStep,
    BackURLStep,
    BeanParameterStep,
    BuildStep,
    CMDStep,
    FragmentIdentifierStep,
    KeywordsStep,
    MVCPathStep,
    MVCRenderCommandNameStep,
    NavigationStep,
    ParameterStep,
    PortletModeStep,
    PortletResourceStep,
    RedirectStep,
    SecureStep,
    Tabs1Step,
    Tabs2Step,
    WindowStateStep {
        private static final String[][] _RESERVED_KEYWORDS = new String[][]{{"cmd", "setCMD"}, {"backURL", "setBackURL"}, {"keywords", "setKeywords"}, {"mvcPath", "setMVCPath"}, {"mvcRenderCommandName", "setMVCRenderCommandName"}, {"navigation", "setNavigation"}, {"p_p_mode", "setPortletMode"}, {"p_p_state", "setWindowState"}, {"portletResource", "setPortletResource"}, {"redirect", "setRedirect"}, {"tabs1", "setTabs1"}, {"tabs2", "setTabs2"}};
        private final RenderURL _renderURL;

        public RenderURLStep(RenderURL renderURL) {
            this._renderURL = renderURL;
        }

        @Override
        public RenderURL buildRenderURL() {
            return this._renderURL;
        }

        @Override
        public String buildString() {
            return this._renderURL.toString();
        }

        @Override
        public AfterParameterStep removeParameter(String name) {
            MutableRenderParameters mutableRenderParameters = this._renderURL.getRenderParameters();
            mutableRenderParameters.removeParameter(name);
            return this;
        }

        @Override
        public AfterBackURLStep setBackURL(String value) {
            this._setParameter("backURL", value, false);
            return this;
        }

        @Override
        public AfterBackURLStep setBackURL(UnsafeSupplier<Object, Exception> valueUnsafeSupplier) {
            this._setParameter("backURL", valueUnsafeSupplier, false);
            return this;
        }

        @Override
        public AfterBeanParameterStep setBeanParameter(PortletSerializable portletSerializable) {
            this._renderURL.setBeanParameter(portletSerializable);
            return this;
        }

        @Override
        public AfterCMDStep setCMD(String value) {
            this._setParameter("cmd", value, false);
            return this;
        }

        @Override
        public AfterCMDStep setCMD(UnsafeSupplier<Object, Exception> valueUnsafeSupplier) {
            this._setParameter("cmd", valueUnsafeSupplier, false);
            return this;
        }

        @Override
        public AfterFragmentIdentifierStep setFragmentIdentifier(String fragment) {
            this._renderURL.setFragmentIdentifier(fragment);
            return this;
        }

        @Override
        public AfterKeywordsStep setKeywords(String value) {
            this._setParameter("keywords", value, false);
            return this;
        }

        @Override
        public AfterKeywordsStep setKeywords(UnsafeSupplier<Object, Exception> valueUnsafeSupplier) {
            this._setParameter("keywords", valueUnsafeSupplier, false);
            return this;
        }

        @Override
        public AfterMVCPathStep setMVCPath(String value) {
            this._setParameter("mvcPath", value, false);
            return this;
        }

        @Override
        public AfterMVCPathStep setMVCPath(UnsafeSupplier<Object, Exception> valueUnsafeSupplier) {
            this._setParameter("mvcPath", valueUnsafeSupplier, false);
            return this;
        }

        @Override
        public AfterMVCRenderCommandNameStep setMVCRenderCommandName(String value) {
            this._setParameter("mvcRenderCommandName", value, false);
            return this;
        }

        @Override
        public AfterMVCRenderCommandNameStep setMVCRenderCommandName(String value, boolean allowNullValue) {
            if (allowNullValue || Validator.isNotNull(value)) {
                this._setParameter("mvcRenderCommandName", value, false);
            }
            return this;
        }

        @Override
        public AfterMVCRenderCommandNameStep setMVCRenderCommandName(UnsafeSupplier<Object, Exception> valueUnsafeSupplier) {
            this._setParameter("mvcRenderCommandName", valueUnsafeSupplier, false);
            return this;
        }

        @Override
        public AfterNavigationStep setNavigation(String value) {
            this._setParameter("navigation", value, false);
            return this;
        }

        @Override
        public AfterNavigationStep setNavigation(UnsafeSupplier<Object, Exception> valueUnsafeSupplier) {
            this._setParameter("navigation", valueUnsafeSupplier, false);
            return this;
        }

        @Override
        public AfterParameterStep setParameter(String key, Object value) {
            this._setParameter(key, String.valueOf(value), true);
            return this;
        }

        @Override
        public AfterParameterStep setParameter(String name, Object value, boolean allowNullValue) {
            this.setParameter(name, String.valueOf(value), allowNullValue);
            return this;
        }

        @Override
        public AfterParameterStep setParameter(String key, String value) {
            this._setParameter(key, value, true);
            return this;
        }

        @Override
        public AfterParameterStep setParameter(String key, String ... values) {
            MutableRenderParameters mutableRenderParameters = this._renderURL.getRenderParameters();
            mutableRenderParameters.setValues(key, values);
            return this;
        }

        @Override
        public AfterParameterStep setParameter(String name, String value, boolean allowNullValue) {
            if (allowNullValue || Validator.isNotNull(value)) {
                this._setParameter(name, value, true);
            }
            return this;
        }

        @Override
        public AfterParameterStep setParameter(String key, UnsafeSupplier<Object, Exception> valueUnsafeSupplier) {
            this._setParameter(key, valueUnsafeSupplier, true);
            return this;
        }

        @Override
        public AfterParameterStep setParameters(PortletParameters portletParameters) {
            MutableRenderParameters mutableRenderParameters = this._renderURL.getRenderParameters();
            mutableRenderParameters.set(portletParameters);
            return this;
        }

        @Override
        public AfterPortletModeStep setPortletMode(PortletMode portletMode) {
            try {
                this._renderURL.setPortletMode(portletMode);
            }
            catch (PortletModeException portletModeException) {
                throw new SystemException(portletModeException);
            }
            return this;
        }

        @Override
        public AfterPortletResourceStep setPortletResource(String value) {
            this._setParameter("portletResource", value, false);
            return this;
        }

        @Override
        public AfterPortletResourceStep setPortletResource(UnsafeSupplier<Object, Exception> valueUnsafeSupplier) {
            this._setParameter("portletResource", valueUnsafeSupplier, false);
            return this;
        }

        @Override
        public AfterRedirectStep setRedirect(Object value) {
            this._setParameter("redirect", String.valueOf(value), false);
            return this;
        }

        @Override
        public AfterRedirectStep setRedirect(String value) {
            this._setParameter("redirect", value, false);
            return this;
        }

        @Override
        public AfterRedirectStep setRedirect(UnsafeSupplier<Object, Exception> valueUnsafeSupplier) {
            this._setParameter("redirect", valueUnsafeSupplier, false);
            return this;
        }

        @Override
        public AfterSecureStep setSecure(boolean secure) {
            try {
                this._renderURL.setSecure(secure);
            }
            catch (PortletSecurityException portletSecurityException) {
                throw new SystemException(portletSecurityException);
            }
            return this;
        }

        @Override
        public AfterTabs1Step setTabs1(String value) {
            this._setParameter("tabs1", value, false);
            return this;
        }

        @Override
        public AfterTabs1Step setTabs1(UnsafeSupplier<Object, Exception> valueUnsafeSupplier) {
            this._setParameter("tabs1", valueUnsafeSupplier, false);
            return this;
        }

        @Override
        public AfterTabs2Step setTabs2(String value) {
            this._setParameter("tabs2", value, false);
            return this;
        }

        @Override
        public AfterTabs2Step setTabs2(UnsafeSupplier<Object, Exception> valueUnsafeSupplier) {
            this._setParameter("tabs2", valueUnsafeSupplier, false);
            return this;
        }

        @Override
        public AfterWindowStateStep setWindowState(WindowState windowState) {
            try {
                this._renderURL.setWindowState(windowState);
            }
            catch (WindowStateException windowStateException) {
                throw new SystemException(windowStateException);
            }
            return this;
        }

        private void _setParameter(String key, String value, boolean validateKey) {
            if (validateKey) {
                this._validateKey(key);
            }
            MutableRenderParameters mutableRenderParameters = this._renderURL.getRenderParameters();
            mutableRenderParameters.setValue(key, value);
        }

        private void _setParameter(String key, UnsafeSupplier<Object, Exception> valueUnsafeSupplier, boolean validateKey) {
            if (validateKey) {
                this._validateKey(key);
            }
            try {
                Object value = valueUnsafeSupplier.get();
                if (value == null) {
                    return;
                }
                MutableRenderParameters mutableRenderParameters = this._renderURL.getRenderParameters();
                if (value instanceof String[]) {
                    mutableRenderParameters.setValues(key, (String[])value);
                } else {
                    mutableRenderParameters.setValue(key, String.valueOf(value));
                }
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        private void _validateKey(String key) {
            if (key == null) {
                return;
            }
            for (String[] reservedKeywordArray : _RESERVED_KEYWORDS) {
                String reservedKey = reservedKeywordArray[0];
                if (!key.equals(reservedKey)) continue;
                throw new RuntimeException(StringBundler.concat((String[])new String[]{"Use method \"", reservedKeywordArray[1], "\" when setting value for \"", reservedKey, "\""}));
            }
        }
    }

    public static interface WindowStateStep {
        public AfterWindowStateStep setWindowState(WindowState var1);
    }

    @FunctionalInterface
    public static interface UnsafeSupplier<T, E extends Throwable> {
        public T get() throws E;
    }

    public static interface Tabs2Step {
        public AfterTabs2Step setTabs2(String var1);

        public AfterTabs2Step setTabs2(UnsafeSupplier<Object, Exception> var1);
    }

    public static interface Tabs1Step {
        public AfterTabs1Step setTabs1(String var1);

        public AfterTabs1Step setTabs1(UnsafeSupplier<Object, Exception> var1);
    }

    public static interface SecureStep {
        public AfterSecureStep setSecure(boolean var1);
    }

    public static interface RedirectStep {
        public AfterRedirectStep setRedirect(Object var1);

        public AfterRedirectStep setRedirect(String var1);

        public AfterRedirectStep setRedirect(UnsafeSupplier<Object, Exception> var1);
    }

    public static interface PortletResourceStep {
        public AfterPortletResourceStep setPortletResource(String var1);

        public AfterPortletResourceStep setPortletResource(UnsafeSupplier<Object, Exception> var1);
    }

    public static interface PortletModeStep {
        public AfterPortletModeStep setPortletMode(PortletMode var1);
    }

    public static interface ParameterStep {
        public AfterParameterStep removeParameter(String var1);

        public AfterParameterStep setParameter(String var1, Object var2);

        public AfterParameterStep setParameter(String var1, Object var2, boolean var3);

        public AfterParameterStep setParameter(String var1, String var2);

        public AfterParameterStep setParameter(String var1, String ... var2);

        public AfterParameterStep setParameter(String var1, String var2, boolean var3);

        public AfterParameterStep setParameter(String var1, UnsafeSupplier<Object, Exception> var2);

        public AfterParameterStep setParameters(PortletParameters var1);
    }

    public static interface NavigationStep {
        public AfterNavigationStep setNavigation(String var1);

        public AfterNavigationStep setNavigation(UnsafeSupplier<Object, Exception> var1);
    }

    public static interface MVCRenderCommandNameStep {
        public AfterMVCRenderCommandNameStep setMVCRenderCommandName(String var1);

        public AfterMVCRenderCommandNameStep setMVCRenderCommandName(String var1, boolean var2);

        public AfterMVCRenderCommandNameStep setMVCRenderCommandName(UnsafeSupplier<Object, Exception> var1);
    }

    public static interface MVCPathStep {
        public AfterMVCPathStep setMVCPath(String var1);

        public AfterMVCPathStep setMVCPath(UnsafeSupplier<Object, Exception> var1);
    }

    public static interface KeywordsStep {
        public AfterKeywordsStep setKeywords(String var1);

        public AfterKeywordsStep setKeywords(UnsafeSupplier<Object, Exception> var1);
    }

    public static interface FragmentIdentifierStep {
        public AfterFragmentIdentifierStep setFragmentIdentifier(String var1);
    }

    public static interface CMDStep {
        public AfterCMDStep setCMD(String var1);

        public AfterCMDStep setCMD(UnsafeSupplier<Object, Exception> var1);
    }

    public static interface BuildStep {
        public RenderURL buildRenderURL();

        public String buildString();
    }

    public static interface BeanParameterStep {
        public AfterBeanParameterStep setBeanParameter(PortletSerializable var1);
    }

    public static interface BackURLStep {
        public AfterBackURLStep setBackURL(String var1);

        public AfterBackURLStep setBackURL(UnsafeSupplier<Object, Exception> var1);
    }

    public static interface AfterWindowStateStep
    extends BuildStep {
    }

    public static interface AfterTabs2Step
    extends BeanParameterStep,
    BuildStep,
    FragmentIdentifierStep,
    ParameterStep,
    PortletModeStep,
    SecureStep,
    WindowStateStep {
    }

    public static interface AfterTabs1Step
    extends BeanParameterStep,
    BuildStep,
    FragmentIdentifierStep,
    ParameterStep,
    PortletModeStep,
    SecureStep,
    Tabs2Step,
    WindowStateStep {
    }

    public static interface AfterSecureStep
    extends BuildStep,
    WindowStateStep {
    }

    public static interface AfterRedirectStep
    extends BackURLStep,
    BeanParameterStep,
    BuildStep,
    FragmentIdentifierStep,
    KeywordsStep,
    NavigationStep,
    ParameterStep,
    PortletModeStep,
    PortletResourceStep,
    SecureStep,
    Tabs1Step,
    Tabs2Step,
    WindowStateStep {
    }

    public static interface AfterPortletResourceStep
    extends BeanParameterStep,
    BuildStep,
    FragmentIdentifierStep,
    ParameterStep,
    PortletModeStep,
    SecureStep,
    Tabs1Step,
    Tabs2Step,
    WindowStateStep {
    }

    public static interface AfterPortletModeStep
    extends BuildStep,
    SecureStep,
    WindowStateStep {
    }

    public static interface AfterParameterStep
    extends BuildStep,
    ParameterStep,
    PortletModeStep,
    SecureStep,
    WindowStateStep {
    }

    public static interface AfterNavigationStep
    extends BeanParameterStep,
    BuildStep,
    FragmentIdentifierStep,
    ParameterStep,
    PortletModeStep,
    PortletResourceStep,
    SecureStep,
    Tabs1Step,
    Tabs2Step,
    WindowStateStep {
    }

    public static interface AfterMVCRenderCommandNameStep
    extends BackURLStep,
    BeanParameterStep,
    BuildStep,
    CMDStep,
    FragmentIdentifierStep,
    KeywordsStep,
    NavigationStep,
    ParameterStep,
    PortletModeStep,
    PortletResourceStep,
    RedirectStep,
    SecureStep,
    Tabs1Step,
    Tabs2Step,
    WindowStateStep {
    }

    public static interface AfterMVCPathStep
    extends BackURLStep,
    BeanParameterStep,
    BuildStep,
    CMDStep,
    FragmentIdentifierStep,
    KeywordsStep,
    MVCRenderCommandNameStep,
    NavigationStep,
    ParameterStep,
    PortletModeStep,
    PortletResourceStep,
    RedirectStep,
    SecureStep,
    Tabs1Step,
    Tabs2Step,
    WindowStateStep {
    }

    public static interface AfterKeywordsStep
    extends BeanParameterStep,
    BuildStep,
    FragmentIdentifierStep,
    NavigationStep,
    ParameterStep,
    PortletModeStep,
    PortletResourceStep,
    SecureStep,
    Tabs1Step,
    Tabs2Step,
    WindowStateStep {
    }

    public static interface AfterFragmentIdentifierStep
    extends BuildStep,
    ParameterStep,
    PortletModeStep,
    SecureStep,
    WindowStateStep {
    }

    public static interface AfterCMDStep
    extends BackURLStep,
    BeanParameterStep,
    BuildStep,
    FragmentIdentifierStep,
    KeywordsStep,
    NavigationStep,
    ParameterStep,
    PortletModeStep,
    PortletResourceStep,
    RedirectStep,
    SecureStep,
    Tabs1Step,
    Tabs2Step,
    WindowStateStep {
    }

    public static interface AfterBeanParameterStep
    extends BuildStep,
    FragmentIdentifierStep,
    ParameterStep,
    PortletModeStep,
    SecureStep,
    WindowStateStep {
    }

    public static interface AfterBackURLStep
    extends BeanParameterStep,
    BuildStep,
    FragmentIdentifierStep,
    KeywordsStep,
    NavigationStep,
    ParameterStep,
    PortletModeStep,
    PortletResourceStep,
    SecureStep,
    Tabs1Step,
    Tabs2Step,
    WindowStateStep {
    }
}

