/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.sanitizer;

import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.sanitizer.Sanitizer;
import com.liferay.portal.kernel.sanitizer.SanitizerException;
import java.util.Map;
import org.osgi.framework.BundleContext;

public class SanitizerUtil {
    private static final ServiceTrackerList<Sanitizer> _sanitizers = ServiceTrackerListFactory.open((BundleContext)SystemBundleUtil.getBundleContext(), Sanitizer.class);

    public static String sanitize(long companyId, long groupId, long userId, String className, long classPK, String contentType, String content) throws SanitizerException {
        return SanitizerUtil.sanitize(companyId, groupId, userId, className, classPK, contentType, "ALL", content, null);
    }

    public static String sanitize(long companyId, long groupId, long userId, String className, long classPK, String contentType, String mode, String s, Map<String, Object> options) throws SanitizerException {
        return SanitizerUtil.sanitize(companyId, groupId, userId, className, classPK, contentType, new String[]{mode}, s, options);
    }

    public static String sanitize(long companyId, long groupId, long userId, String className, long classPK, String contentType, String[] modes, String content, Map<String, Object> options) throws SanitizerException {
        for (Sanitizer sanitizer : _sanitizers) {
            content = sanitizer.sanitize(companyId, groupId, userId, className, classPK, contentType, modes, content, options);
        }
        return content;
    }
}

