/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.scheduler;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.cal.DayAndPosition;
import com.liferay.portal.kernel.cal.Duration;
import com.liferay.portal.kernel.cal.Recurrence;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.text.Format;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.portlet.PortletRequest;

public class CronTextUtil {
    public static String getCronText(PortletRequest portletRequest, Calendar calendar, boolean timeZoneSensitive, int recurrenceType) {
        Calendar recurrenceCalendar = null;
        if (timeZoneSensitive) {
            recurrenceCalendar = CalendarFactoryUtil.getCalendar();
            recurrenceCalendar.setTime(calendar.getTime());
        } else {
            recurrenceCalendar = (Calendar)calendar.clone();
        }
        Recurrence recurrence = new Recurrence(recurrenceCalendar, new Duration(1, 0, 0, 0), recurrenceType);
        recurrence.setWeekStart(1);
        if (recurrenceType == 3) {
            int dailyType = ParamUtil.getInteger(portletRequest, "dailyType");
            if (dailyType == 0) {
                recurrence.setInterval(ParamUtil.getInteger(portletRequest, "dailyInterval", 1));
            } else {
                recurrence.setByDay(new DayAndPosition[]{new DayAndPosition(2, 0), new DayAndPosition(3, 0), new DayAndPosition(4, 0), new DayAndPosition(5, 0), new DayAndPosition(6, 0)});
            }
        } else if (recurrenceType == 4) {
            recurrence.setInterval(ParamUtil.getInteger(portletRequest, "weeklyInterval"));
            ArrayList<DayAndPosition> dayPos = new ArrayList<DayAndPosition>();
            CronTextUtil._addWeeklyDayPos(portletRequest, dayPos, 1);
            CronTextUtil._addWeeklyDayPos(portletRequest, dayPos, 2);
            CronTextUtil._addWeeklyDayPos(portletRequest, dayPos, 3);
            CronTextUtil._addWeeklyDayPos(portletRequest, dayPos, 4);
            CronTextUtil._addWeeklyDayPos(portletRequest, dayPos, 5);
            CronTextUtil._addWeeklyDayPos(portletRequest, dayPos, 6);
            CronTextUtil._addWeeklyDayPos(portletRequest, dayPos, 7);
            if (dayPos.isEmpty()) {
                dayPos.add(new DayAndPosition(2, 0));
            }
            recurrence.setByDay(dayPos.toArray(new DayAndPosition[0]));
        } else if (recurrenceType == 5) {
            int monthlyType = ParamUtil.getInteger(portletRequest, "monthlyType");
            if (monthlyType == 0) {
                recurrence.setByMonthDay(new int[]{ParamUtil.getInteger(portletRequest, "monthlyDay0", 1)});
                recurrence.setInterval(ParamUtil.getInteger(portletRequest, "monthlyInterval0", 1));
            } else {
                recurrence.setByDay(new DayAndPosition[]{new DayAndPosition(ParamUtil.getInteger(portletRequest, "monthlyDay1"), ParamUtil.getInteger(portletRequest, "monthlyPos"))});
                recurrence.setInterval(ParamUtil.getInteger(portletRequest, "monthlyInterval1", 1));
            }
        } else if (recurrenceType == 6) {
            int yearlyType = ParamUtil.getInteger(portletRequest, "yearlyType");
            if (yearlyType == 0) {
                recurrence.setByMonth(new int[]{ParamUtil.getInteger(portletRequest, "yearlyMonth0")});
                recurrence.setByMonthDay(new int[]{ParamUtil.getInteger(portletRequest, "yearlyDay0", 1)});
                recurrence.setInterval(ParamUtil.getInteger(portletRequest, "yearlyInterval0", 1));
            } else {
                recurrence.setByDay(new DayAndPosition[]{new DayAndPosition(ParamUtil.getInteger(portletRequest, "yearlyDay1"), ParamUtil.getInteger(portletRequest, "yearlyPos"))});
                recurrence.setByMonth(new int[]{ParamUtil.getInteger(portletRequest, "yearlyMonth1")});
                recurrence.setInterval(ParamUtil.getInteger(portletRequest, "yearlyInterval1", 1));
            }
        }
        return CronTextUtil._toCronText(recurrence);
    }

    private static void _addWeeklyDayPos(PortletRequest portletRequest, List<DayAndPosition> list, int day) {
        if (ParamUtil.getBoolean(portletRequest, "weeklyDayPos" + day)) {
            list.add(new DayAndPosition(day, 0));
        }
    }

    private static String _getDayOfWeek(DayAndPosition dayPos) {
        Calendar calendar = CalendarFactoryUtil.getCalendar();
        calendar.set(7, dayPos.getDayOfWeek());
        Format format = FastDateFormatFactoryUtil.getSimpleDateFormat("EEE", LocaleUtil.US);
        return StringUtil.toUpperCase(format.format(calendar));
    }

    private static String _getIntervalValue(int interval, int period) {
        if (interval <= 0 && period == 4) {
            return "";
        }
        if (interval <= 0) {
            return "/1";
        }
        return "/" + interval;
    }

    private static String _toCronText(Recurrence recurrence) {
        Calendar dtStart = recurrence.getDtStart();
        int frequency = recurrence.getFrequency();
        int interval = recurrence.getInterval();
        DayAndPosition[] byDay = recurrence.getByDay();
        int[] byMonthDay = recurrence.getByMonthDay();
        String startDateSecond = String.valueOf(dtStart.get(13));
        String startDateMinute = String.valueOf(dtStart.get(12));
        int startDateHour = dtStart.get(10);
        if (dtStart.get(9) == 1) {
            startDateHour += 12;
        }
        Object dayOfMonth = String.valueOf(dtStart.get(5));
        Object month = String.valueOf(dtStart.get(2) + 1);
        Object dayOfWeek = String.valueOf(dtStart.get(7));
        Object year = String.valueOf(dtStart.get(1));
        if (frequency == 7) {
            dayOfWeek = "?";
        } else if (frequency == 3) {
            dayOfMonth = "1" + CronTextUtil._getIntervalValue(interval, 3);
            month = "*";
            dayOfWeek = "?";
            year = "*";
            if (byDay != null) {
                dayOfMonth = "?";
                dayOfWeek = "";
                for (int i = 0; i < byDay.length; ++i) {
                    if (i > 0) {
                        dayOfWeek = (String)dayOfWeek + ",";
                    }
                    dayOfWeek = (String)dayOfWeek + CronTextUtil._getDayOfWeek(byDay[i]);
                }
            }
        } else if (frequency == 4) {
            dayOfMonth = "?";
            month = "*";
            year = "*";
            if (byDay != null) {
                dayOfWeek = "";
                for (int i = 0; i < byDay.length; ++i) {
                    if (i > 0) {
                        dayOfWeek = (String)dayOfWeek + ",";
                    }
                    dayOfWeek = (String)dayOfWeek + CronTextUtil._getDayOfWeek(byDay[i]);
                }
            }
            dayOfWeek = (String)dayOfWeek + CronTextUtil._getIntervalValue(interval, 4);
        } else if (frequency == 5) {
            dayOfMonth = "?";
            month = "1" + CronTextUtil._getIntervalValue(interval, 5);
            dayOfWeek = "?";
            year = "*";
            if (byMonthDay != null && byMonthDay.length == 1) {
                dayOfMonth = String.valueOf(byMonthDay[0]);
            } else if (byDay != null && byDay.length == 1) {
                String pos = String.valueOf(byDay[0].getDayPosition());
                dayOfWeek = pos.equals("-1") ? CronTextUtil._getDayOfWeek(byDay[0]) + "L" : CronTextUtil._getDayOfWeek(byDay[0]) + "#" + pos;
            }
        } else if (frequency == 6) {
            int[] byMonth = recurrence.getByMonth();
            dayOfMonth = "?";
            dayOfWeek = "?";
            year = (String)year + CronTextUtil._getIntervalValue(interval, 6);
            if (byMonth != null && byMonth.length == 1) {
                month = String.valueOf(byMonth[0] + 1);
                if (byMonthDay != null && byMonthDay.length == 1) {
                    dayOfMonth = String.valueOf(byMonthDay[0]);
                } else if (byDay != null && byDay.length == 1) {
                    String pos = String.valueOf(byDay[0].getDayPosition());
                    dayOfWeek = pos.equals("-1") ? CronTextUtil._getDayOfWeek(byDay[0]) + "L" : CronTextUtil._getDayOfWeek(byDay[0]) + "#" + pos;
                }
            }
        }
        return StringBundler.concat((Object[])new Object[]{startDateSecond, " ", startDateMinute, " ", startDateHour, " ", dayOfMonth, " ", month, " ", dayOfWeek, " ", year});
    }
}

