/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.portal.kernel.search.highlight.HighlightUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Locale;

public class Summary {
    private static final String[] _ESCAPE_SAFE_HIGHLIGHTS = new String[]{"[@HIGHLIGHT1@]", "[@HIGHLIGHT2@]"};
    private String _content;
    private boolean _escape = true;
    private boolean _highlight;
    private Locale _locale;
    private int _maxContentLength;
    private String[] _queryTerms;
    private String _title;

    public Summary(Locale locale, String title, String content) {
        this._locale = locale;
        this._title = title;
        this._content = content;
    }

    public Summary(String title, String content) {
        this(LocaleThreadLocal.getThemeDisplayLocale(), title, content);
    }

    public String getContent() {
        int index;
        if (Validator.isNull(this._content)) {
            return "";
        }
        if (this._maxContentLength <= 0 || this._content.length() <= this._maxContentLength) {
            return this._content;
        }
        if (ArrayUtil.isNotEmpty(this._queryTerms) && (index = StringUtil.indexOfAny(this._content, this._queryTerms)) > this._maxContentLength) {
            this._content = this._content.substring(index);
        }
        this._content = StringUtil.shorten(this._content, this._maxContentLength);
        return this._content;
    }

    public String getHighlightedContent() {
        return this._escapeAndHighlight(this._content);
    }

    public String getHighlightedTitle() {
        return this._escapeAndHighlight(this._title);
    }

    public Locale getLocale() {
        return this._locale;
    }

    public int getMaxContentLength() {
        return this._maxContentLength;
    }

    public String[] getQueryTerms() {
        return this._queryTerms;
    }

    public String getTitle() {
        if (Validator.isNull(this._title)) {
            return "";
        }
        return this._title;
    }

    public boolean isEscape() {
        return this._escape;
    }

    public boolean isHighlight() {
        return this._highlight;
    }

    public void setContent(String content) {
        this._content = content;
    }

    public void setEscape(boolean escape) {
        this._escape = escape;
    }

    public void setHighlight(boolean highlight) {
        this._highlight = highlight;
    }

    public void setLocale(Locale locale) {
        this._locale = locale;
    }

    public void setMaxContentLength(int maxContentLength) {
        this._maxContentLength = maxContentLength;
    }

    public void setQueryTerms(String[] queryTerms) {
        if (ArrayUtil.isEmpty(queryTerms)) {
            return;
        }
        this._queryTerms = queryTerms;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    private String _escapeAndHighlight(String text) {
        if (!this._highlight || Validator.isNull(text) || ArrayUtil.isEmpty(this._queryTerms)) {
            if (this._escape) {
                return HtmlUtil.escape(text);
            }
            return text;
        }
        text = HighlightUtil.highlight(text, this._queryTerms, _ESCAPE_SAFE_HIGHLIGHTS[0], _ESCAPE_SAFE_HIGHLIGHTS[1]);
        if (this._escape) {
            text = HtmlUtil.escape(text);
        }
        return StringUtil.replace(text, _ESCAPE_SAFE_HIGHLIGHTS, HighlightUtil.HIGHLIGHTS);
    }
}

