/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search.filter;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.search.BooleanClause;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.filter.BaseFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.FilterVisitor;
import com.liferay.portal.kernel.search.filter.RangeTermFilter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.search.generic.BooleanClauseImpl;
import com.liferay.portal.kernel.util.SortedArrayList;
import java.util.Comparator;
import java.util.List;

public class BooleanFilter
extends BaseFilter {
    private final List<BooleanClause<Filter>> _mustBooleanClauses = new SortedArrayList<BooleanClause<Filter>>(new BooleanClauseComparator());
    private final List<BooleanClause<Filter>> _mustNotBooleanClauses = new SortedArrayList<BooleanClause<Filter>>(new BooleanClauseComparator());
    private final List<BooleanClause<Filter>> _shouldBooleanClauses = new SortedArrayList<BooleanClause<Filter>>(new BooleanClauseComparator());

    @Override
    public <T> T accept(FilterVisitor<T> filterVisitor) {
        return filterVisitor.visit(this);
    }

    public Filter add(Filter filter) {
        return this.add(filter, BooleanClauseOccur.SHOULD);
    }

    public Filter add(Filter filter, BooleanClauseOccur booleanClauseOccur) {
        BooleanClauseImpl<Filter> booleanClause = new BooleanClauseImpl<Filter>(filter, booleanClauseOccur);
        if (booleanClauseOccur.equals(BooleanClauseOccur.MUST)) {
            this._mustBooleanClauses.add(booleanClause);
        } else if (booleanClauseOccur.equals(BooleanClauseOccur.MUST_NOT)) {
            this._mustNotBooleanClauses.add(booleanClause);
        } else {
            this._shouldBooleanClauses.add(booleanClause);
        }
        return filter;
    }

    public Filter addRangeTerm(String field, int startValue, int endValue) {
        RangeTermFilter rangeTermFilter = new RangeTermFilter(field, true, true, String.valueOf(startValue), String.valueOf(endValue));
        return this.add(rangeTermFilter, BooleanClauseOccur.SHOULD);
    }

    public Filter addRangeTerm(String field, Integer startValue, Integer endValue) {
        return this.addRangeTerm(field, (int)startValue, (int)endValue);
    }

    public Filter addRangeTerm(String field, long startValue, long endValue) {
        RangeTermFilter rangeTermFilter = new RangeTermFilter(field, true, true, String.valueOf(startValue), String.valueOf(endValue));
        return this.add(rangeTermFilter, BooleanClauseOccur.SHOULD);
    }

    public Filter addRangeTerm(String field, Long startValue, Long endValue) {
        return this.addRangeTerm(field, (long)startValue, (long)endValue);
    }

    public Filter addRangeTerm(String field, short startValue, short endValue) {
        RangeTermFilter rangeTermFilter = new RangeTermFilter(field, true, true, String.valueOf(startValue), String.valueOf(endValue));
        return this.add(rangeTermFilter, BooleanClauseOccur.SHOULD);
    }

    public Filter addRangeTerm(String field, Short startValue, Short endValue) {
        return this.addRangeTerm(field, (short)startValue, (short)endValue);
    }

    public Filter addRangeTerm(String field, String startValue, String endValue) {
        RangeTermFilter rangeTermFilter = new RangeTermFilter(field, true, true, startValue, endValue);
        return this.add(rangeTermFilter, BooleanClauseOccur.SHOULD);
    }

    public Filter addRequiredTerm(String field, boolean value) {
        return this.addRequiredTerm(field, String.valueOf(value));
    }

    public Filter addRequiredTerm(String field, Boolean value) {
        return this.addRequiredTerm(field, String.valueOf(value));
    }

    public Filter addRequiredTerm(String field, double value) {
        return this.addRequiredTerm(field, String.valueOf(value));
    }

    public Filter addRequiredTerm(String field, Double value) {
        return this.addRequiredTerm(field, String.valueOf(value));
    }

    public Filter addRequiredTerm(String field, int value) {
        return this.addRequiredTerm(field, String.valueOf(value));
    }

    public Filter addRequiredTerm(String field, Integer value) {
        return this.addRequiredTerm(field, String.valueOf(value));
    }

    public Filter addRequiredTerm(String field, long value) {
        return this.addRequiredTerm(field, String.valueOf(value));
    }

    public Filter addRequiredTerm(String field, Long value) {
        return this.addRequiredTerm(field, String.valueOf(value));
    }

    public Filter addRequiredTerm(String field, short value) {
        return this.addRequiredTerm(field, String.valueOf(value));
    }

    public Filter addRequiredTerm(String field, Short value) {
        return this.addRequiredTerm(field, String.valueOf(value));
    }

    public Filter addRequiredTerm(String field, String value) {
        return this.add(new TermFilter(field, value), BooleanClauseOccur.MUST);
    }

    public Filter addTerm(String field, boolean value) {
        return this.addTerm(field, String.valueOf(value));
    }

    public Filter addTerm(String field, Boolean value) {
        return this.addTerm(field, String.valueOf(value));
    }

    public Filter addTerm(String field, double value) {
        return this.addTerm(field, String.valueOf(value));
    }

    public Filter addTerm(String field, Double value) {
        return this.addTerm(field, String.valueOf(value));
    }

    public Filter addTerm(String field, int value) {
        return this.addTerm(field, String.valueOf(value));
    }

    public Filter addTerm(String field, Integer value) {
        return this.addTerm(field, String.valueOf(value));
    }

    public Filter addTerm(String field, long value) {
        return this.addTerm(field, String.valueOf(value));
    }

    public Filter addTerm(String field, Long value) {
        return this.addTerm(field, String.valueOf(value));
    }

    public Filter addTerm(String field, short value) {
        return this.addTerm(field, String.valueOf(value));
    }

    public Filter addTerm(String field, Short value) {
        return this.addTerm(field, String.valueOf(value));
    }

    public Filter addTerm(String field, String value) {
        return this.addTerm(field, value, BooleanClauseOccur.SHOULD);
    }

    public Filter addTerm(String field, String value, BooleanClauseOccur booleanClauseOccur) {
        return this.add(new TermFilter(field, value), booleanClauseOccur);
    }

    public List<BooleanClause<Filter>> getMustBooleanClauses() {
        return this._mustBooleanClauses;
    }

    public List<BooleanClause<Filter>> getMustNotBooleanClauses() {
        return this._mustNotBooleanClauses;
    }

    public List<BooleanClause<Filter>> getShouldBooleanClauses() {
        return this._shouldBooleanClauses;
    }

    @Override
    public int getSortOrder() {
        return 10;
    }

    public boolean hasClauses() {
        return !this._mustBooleanClauses.isEmpty() || !this._mustNotBooleanClauses.isEmpty() || !this._shouldBooleanClauses.isEmpty();
    }

    @Override
    public String toString() {
        return StringBundler.concat((String[])new String[]{"{MUST(", this.getBooleanClauseString(this._mustBooleanClauses), "), MUST_NOT(", this.getBooleanClauseString(this._mustNotBooleanClauses), "), SHOULD(", this.getBooleanClauseString(this._shouldBooleanClauses), "), ", super.toString(), "}"});
    }

    protected String getBooleanClauseString(List<BooleanClause<Filter>> booleanClauses) {
        StringBundler sb = new StringBundler(2 * booleanClauses.size());
        for (BooleanClause<Filter> booleanClause : booleanClauses) {
            sb.append(booleanClause);
            sb.append(", ");
        }
        return sb.toString();
    }

    private static class BooleanClauseComparator
    implements Comparator<BooleanClause<Filter>> {
        private BooleanClauseComparator() {
        }

        @Override
        public int compare(BooleanClause<Filter> booleanClause1, BooleanClause<Filter> booleanClause2) {
            Filter filter1 = booleanClause1.getClause();
            Filter filter2 = booleanClause2.getClause();
            if (filter1.getSortOrder() < filter2.getSortOrder()) {
                return -1;
            }
            if (filter1.getSortOrder() > filter2.getSortOrder()) {
                return 1;
            }
            return 0;
        }
    }
}

