/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search.filter;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.search.filter.BaseFilter;
import com.liferay.portal.kernel.search.filter.FilterVisitor;

public class RangeTermFilter
extends BaseFilter {
    private final String _field;
    private final boolean _includesLower;
    private final boolean _includesUpper;
    private String _lowerBound;
    private Operator _lowerBoundOperator;
    private String _upperBound;
    private Operator _upperBoundOperator;

    public RangeTermFilter(String field, boolean includesLower, boolean includesUpper) {
        this._field = field;
        this._includesLower = includesLower;
        this._includesUpper = includesUpper;
        this.setOperators(includesLower, includesUpper);
    }

    public RangeTermFilter(String field, boolean includesLower, boolean includesUpper, String lowerBound, String upperBound) {
        this._field = field;
        this._includesLower = includesLower;
        this._includesUpper = includesUpper;
        this._lowerBound = lowerBound;
        this._upperBound = upperBound;
        this.setOperators(includesLower, includesUpper);
    }

    @Override
    public <T> T accept(FilterVisitor<T> filterVisitor) {
        return filterVisitor.visit(this);
    }

    public String getField() {
        return this._field;
    }

    public String getLowerBound() {
        return this._lowerBound;
    }

    public Operator getLowerBoundOperator() {
        return this._lowerBoundOperator;
    }

    @Override
    public int getSortOrder() {
        return 20;
    }

    public String getUpperBound() {
        return this._upperBound;
    }

    public Operator getUpperBoundOperator() {
        return this._upperBoundOperator;
    }

    public boolean isIncludesLower() {
        return this._includesLower;
    }

    public boolean isIncludesUpper() {
        return this._includesUpper;
    }

    public void setLowerBound(String lowerBound) {
        this._lowerBound = lowerBound;
    }

    public void setUpperBound(String upperBound) {
        this._upperBound = upperBound;
    }

    @Override
    public String toString() {
        return StringBundler.concat((Object[])new Object[]{"{(", this._lowerBound, this._lowerBoundOperator, this._field, this._upperBoundOperator, this._upperBound, "), ", super.toString(), "}"});
    }

    protected void setOperators(boolean includesLower, boolean includesUpper) {
        this._lowerBoundOperator = includesLower ? Operator.GTE : Operator.GT;
        this._upperBoundOperator = includesUpper ? Operator.LTE : Operator.LT;
    }

    public static enum Operator {
        GT,
        GTE,
        LT,
        LTE;


        public String toString() {
            String name = this.name();
            if (name.equals(GT.name())) {
                return ">";
            }
            if (name.equals(GTE.name())) {
                return ">=";
            }
            if (name.equals(LT.name())) {
                return "<";
            }
            if (name.equals(LTE.name())) {
                return "<=";
            }
            return "";
        }
    }
}

